/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.ssp;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import net.minidev.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.ssp.ISSPApi;
import org.jasig.portlet.notice.service.ssp.ISSPPersonLookup;
import org.jasig.portlet.notice.service.ssp.MarkTaskCompletedAction;
import org.jasig.portlet.notice.service.ssp.SSPApiRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class SSPTaskNotificationService
extends AbstractNotificationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String NOTIFICATION_CATEGORY_PREF = "SSPTaskNotificationService.categoryName";
    private static final String SSP_NOTIFICATIONS_ENABLED = "SSPTaskNotificationService.enabled";
    private static final String SSP_NOTIFICATIONS_ENABLE_MARK_COMPLETED = "SSPTaskNotificationService.enableMarkCompletedAction";
    private static final String DEFAULT_CATEGORY = "Student Success Plan";
    private static final String NOTIFICATION_SOURCE_PREF = "SSPTaskNotificationService.sourceName";
    private static final String DEFAULT_NOTIFICATION_SOURCE = "Student Success Plan";
    private static final String SUCCESS_QUERY = "$.success";
    private static final String MESSAGE_QUERY = "$.message";
    private static final String ROWS_QUERY = "$.rows";
    private static final String ROW_ID_QUERY_FMT = "$.rows[%d].id";
    private static final String ROW_NAME_QUERY_FMT = "$.rows[%d].name";
    private static final String ROW_DESCRIPTION_QUERY_FMT = "$.rows[%d].description";
    private static final String ROW_DUE_DATE_QUERY_FMT = "$.rows[%d].dueDate";
    private static final String ROW_COMPLETED_QUERY_FMT = "$.rows[%d].completed";
    private static final String ROW_LINK_QUERY_FMT = "$.rows[%d].link";
    private ISSPApi sspApi;
    private ISSPPersonLookup personLookup;
    private String activeTaskURLFragment = "/api/1/person/{personId}/task?STATUS=ACTIVE&limit=1000";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    @Autowired
    public void setSspApi(ISSPApi sspApi) {
        this.sspApi = sspApi;
    }

    @Autowired
    public void setPersonLookup(ISSPPersonLookup personLookup) {
        this.personLookup = personLookup;
    }

    public NotificationResponse fetch(PortletRequest req) {
        ResponseEntity response;
        PortletPreferences preferences = req.getPreferences();
        String enabled = preferences.getValue(SSP_NOTIFICATIONS_ENABLED, "false");
        if (!"true".equalsIgnoreCase(enabled)) {
            return new NotificationResponse();
        }
        String personId = this.getPersonId(req);
        if (personId == null) {
            return new NotificationResponse();
        }
        String urlFragment = this.getActiveTaskUrl();
        SSPApiRequest request = new SSPApiRequest(urlFragment, String.class).addUriParameter("personId", (Object)personId);
        try {
            response = this.sspApi.doRequest(request);
        }
        catch (Exception e) {
            this.log.error("Error reading SSP Notifications: " + e.getMessage());
            return this.notificationError(e.getMessage());
        }
        if (response.getStatusCode().series() != HttpStatus.Series.SUCCESSFUL) {
            this.log.error("Error reading SSP Notifications: " + response);
            return this.notificationError((String)response.getBody());
        }
        NotificationResponse notification = this.mapToNotificationResponse(req, response);
        return notification;
    }

    private NotificationResponse notificationError(String errorMsg) {
        NotificationError error = new NotificationError();
        error.setError(errorMsg);
        error.setSource(this.getClass().getSimpleName());
        NotificationResponse notification = new NotificationResponse();
        notification.setErrors(Arrays.asList(error));
        return notification;
    }

    private NotificationResponse mapToNotificationResponse(PortletRequest request, ResponseEntity<String> response) {
        Configuration config = Configuration.builder().options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).build();
        DocumentContext readContext = JsonPath.using((Configuration)config).parse((String)response.getBody());
        String success = (String)readContext.read(SUCCESS_QUERY, new Predicate[0]);
        if (!"true".equalsIgnoreCase(success)) {
            String error = (String)readContext.read(MESSAGE_QUERY, new Predicate[0]);
            return this.notificationError(error);
        }
        Object rows = readContext.read(ROWS_QUERY, new Predicate[0]);
        if (!(rows instanceof JSONArray)) {
            throw new RuntimeException("Expected 'rows' to be an array of tasks");
        }
        String source = this.getNotificationSource(request);
        ArrayList<NotificationEntry> list = new ArrayList<NotificationEntry>();
        for (int i = 0; i < ((JSONArray)rows).size(); ++i) {
            NotificationEntry entry = this.mapNotificationEntry((ReadContext)readContext, i, source);
            if (entry == null) continue;
            this.attachActions(request, entry);
            list.add(entry);
        }
        NotificationResponse notification = new NotificationResponse();
        if (!list.isEmpty()) {
            NotificationCategory category = this.getNotificationCategory(request);
            category.addEntries(list);
            notification.setCategories(Arrays.asList(category));
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationEntry mapNotificationEntry(ReadContext readContext, int index, String source) {
        NotificationEntry entry;
        block7: {
            boolean completed = (Boolean)readContext.read(String.format(ROW_COMPLETED_QUERY_FMT, index), Boolean.class, new Predicate[0]);
            if (completed) {
                return null;
            }
            entry = new NotificationEntry();
            entry.setSource(source);
            String id = (String)readContext.read(String.format(ROW_ID_QUERY_FMT, index), new Predicate[0]);
            entry.setId(id);
            String title = (String)readContext.read(String.format(ROW_NAME_QUERY_FMT, index), new Predicate[0]);
            entry.setTitle(title);
            String desc = (String)readContext.read(String.format(ROW_DESCRIPTION_QUERY_FMT, index), new Predicate[0]);
            entry.setBody(desc);
            String link = (String)readContext.read(String.format(ROW_LINK_QUERY_FMT, index), new Predicate[0]);
            URL fixedLink = this.normalizeLink(link);
            if (fixedLink != null) {
                entry.setUrl(fixedLink.toExternalForm());
            }
            Date createDate = (Date)readContext.read(String.format("$.rows[%d].createdDate", index), Date.class, new Predicate[0]);
            HashMap<NotificationState, Date> states = new HashMap<NotificationState, Date>();
            states.put(NotificationState.ISSUED, createDate);
            try {
                String dateStr = (String)readContext.read(String.format(ROW_DUE_DATE_QUERY_FMT, index), new Predicate[0]);
                if (StringUtils.isBlank((String)dateStr)) break block7;
                SimpleDateFormat simpleDateFormat = this.dateFormat;
                synchronized (simpleDateFormat) {
                    Date dueDate = this.dateFormat.parse(dateStr);
                    entry.setDueDate(dueDate);
                }
            }
            catch (Exception e) {
                this.log.warn("Error parsing due date.  Ignoring", (Throwable)e);
            }
        }
        return entry;
    }

    private void attachActions(PortletRequest request, NotificationEntry entry) {
        PortletPreferences prefs = request.getPreferences();
        String stringVal = prefs.getValue(SSP_NOTIFICATIONS_ENABLE_MARK_COMPLETED, "false");
        boolean enableMarkCompleted = "true".equalsIgnoreCase(stringVal);
        ArrayList<MarkTaskCompletedAction> actions = new ArrayList<MarkTaskCompletedAction>();
        if (enableMarkCompleted) {
            MarkTaskCompletedAction action = new MarkTaskCompletedAction(entry.getId());
            actions.add(action);
        }
        entry.setAvailableActions(actions);
    }

    private URL normalizeLink(String link) {
        try {
            if (StringUtils.isEmpty((String)link)) {
                return null;
            }
            if (link.startsWith("/")) {
                return this.sspApi.getSSPUrl(link, true);
            }
            if (link.startsWith("http://") || link.startsWith("https://")) {
                return new URL(link);
            }
            return new URL("http://" + link);
        }
        catch (MalformedURLException e) {
            this.log.warn("Bad URL from SSP Entry: " + link, (Throwable)e);
            return null;
        }
    }

    private NotificationCategory getNotificationCategory(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        String title = preferences.getValue(NOTIFICATION_CATEGORY_PREF, "Student Success Plan");
        NotificationCategory category = new NotificationCategory();
        category.setTitle(title);
        return category;
    }

    private String getActiveTaskUrl() {
        return this.activeTaskURLFragment;
    }

    private String getPersonId(PortletRequest req) {
        return this.personLookup.lookupPersonId(req);
    }

    private String getNotificationSource(PortletRequest req) {
        PortletPreferences preferences = req.getPreferences();
        String source = preferences.getValue(NOTIFICATION_SOURCE_PREF, "Student Success Plan");
        return source;
    }
}

