/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.service.rest.RestfulJsonNotificationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.web.client.RestTemplate;

public class OAuth2RestfulJsonNotificationService
extends RestfulJsonNotificationService {
    private static final String SERVICE_URLS_PREFERENCE = "OAuth2RestfulJsonNotificationService.serviceUrls";
    @Value(value="${OAuth2RestfulJsonNotificationService.serviceUrls:}")
    private String serviceUrlsProperty;
    private List<String> serviceUrlsList = Collections.emptyList();
    @Value(value="${OAuth2RestfulJsonNotificationService.clientId:}")
    private String clientId;
    @Value(value="${OAuth2RestfulJsonNotificationService.clientSecret:}")
    private String clientSecret;
    @Value(value="${OAuth2RestfulJsonNotificationService.accessTokenUri:}")
    private String accessTokenUri;
    private OAuth2RestTemplate oAuth2RestTemplate;

    @Override
    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.serviceUrlsProperty)) {
            this.serviceUrlsList = Collections.unmodifiableList(Arrays.asList(this.serviceUrlsProperty.split(",")));
        }
        ClientCredentialsResourceDetails resourceDetails = new ClientCredentialsResourceDetails();
        resourceDetails.setClientId(this.clientId);
        resourceDetails.setClientSecret(this.clientSecret);
        resourceDetails.setAccessTokenUri(this.accessTokenUri);
        this.oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resourceDetails);
    }

    @Override
    protected RestTemplate getRestTemplate() {
        return this.oAuth2RestTemplate;
    }

    @Override
    @Deprecated
    protected List<String> getServiceUrls(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] urls = prefs.getValues(SERVICE_URLS_PREFERENCE, new String[0]);
        return new ArrayList<String>(Arrays.asList(urls));
    }

    @Override
    protected List<String> getServiceUrls() {
        return this.serviceUrlsList;
    }
}

