/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rest.IParameterEvaluator;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class RestfulJsonNotificationService
extends AbstractNotificationService {
    private static final String SERVICE_URLS_PREFERENCE = "RestfulJsonNotificationService.serviceUrls";
    private final ResponseExtractor<NotificationResponse> responseExtractor = new ResponseExtractorImpl();
    private IParameterEvaluator usernameEvaluator = null;
    private IParameterEvaluator passwordEvaluator = null;
    private Map<String, IParameterEvaluator> urlParameters;
    private RestTemplate restTemplate;
    @Value(value="${RestfulJsonNotificationService.serviceUrls:}")
    private String serviceUrlsProperty;
    private List<String> serviceUrlsList = Collections.emptyList();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;

    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    @Autowired
    public void setUrlParameterEvaluators(Set<IParameterEvaluator> evaluators) {
        HashMap map = new HashMap();
        evaluators.forEach(evaluator -> map.put(evaluator.getToken(), evaluator));
        this.urlParameters = Collections.unmodifiableMap(map);
        this.logger.info("Found the following IParameterEvaluator beans:  {}", this.urlParameters);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.serviceUrlsProperty)) {
            this.serviceUrlsList = Collections.unmodifiableList(Arrays.asList(this.serviceUrlsProperty.split(",")));
        }
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        return this.fetchFromServiceUrls(this.getServiceUrls(req), new RequestCallbackImpl(req), this.usernameFinder.findUsername(req), this.createParameters(req));
    }

    @Override
    public NotificationResponse fetch(HttpServletRequest req) {
        return this.fetchFromServiceUrls(this.getServiceUrls(), new RequestCallbackImpl(req), this.usernameFinder.findUsername(req), this.createParameters(req));
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Deprecated
    protected List<String> getServiceUrls(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] urls = prefs.getValues(SERVICE_URLS_PREFERENCE, new String[0]);
        return new ArrayList<String>(Arrays.asList(urls));
    }

    protected List<String> getServiceUrls() {
        return this.serviceUrlsList;
    }

    private NotificationResponse fetchFromServiceUrls(List<String> serviceUrls, RequestCallback requestCallback, String username, Map<String, String> params) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        RestTemplate template = this.getRestTemplate();
        for (String url : serviceUrls) {
            this.logger.debug("Invoking uri '{}' with the following parameters:  {}", (Object)url, params);
            try {
                NotificationResponse response = (NotificationResponse)template.execute(url, HttpMethod.GET, requestCallback, this.responseExtractor, params);
                rslt = rslt.combine(response);
            }
            catch (Exception e) {
                String msg = "Failed to invoke the following service at '" + url + "' for user " + username;
                this.logger.error(msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), "Service Unavailable");
            }
        }
        return rslt;
    }

    @Deprecated
    private Map<String, String> createParameters(PortletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry<String, IParameterEvaluator> y : this.urlParameters.entrySet()) {
            String key = y.getKey();
            String value = this.urlParameters.get(key).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    private Map<String, String> createParameters(HttpServletRequest req) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        for (Map.Entry<String, IParameterEvaluator> y : this.urlParameters.entrySet()) {
            String key = y.getKey();
            String value = this.urlParameters.get(key).evaluate(req);
            rslt.put(key, value);
        }
        return rslt;
    }

    private final class ResponseExtractorImpl
    implements ResponseExtractor<NotificationResponse> {
        private final ObjectMapper mapper = new ObjectMapper();

        private ResponseExtractorImpl() {
        }

        public NotificationResponse extractData(ClientHttpResponse res) {
            NotificationResponse rslt;
            try (InputStream inpt = res.getBody();){
                rslt = (NotificationResponse)this.mapper.readValue(inpt, NotificationResponse.class);
                RestfulJsonNotificationService.this.logger.debug("Produced the following NotificationResponse based on the ClientHttpResponse:  {}", (Object)rslt);
            }
            catch (Throwable t) {
                RestfulJsonNotificationService.this.logger.error("Failed to invoke the remote service at " + res.getHeaders().getLocation(), t);
                NotificationError error = new NotificationError();
                try {
                    error.setError(res.getRawStatusCode() + ":  " + res.getStatusText());
                }
                catch (IOException e) {
                    RestfulJsonNotificationService.this.logger.error("Failed to read the ClientHttpResponse", (Throwable)e);
                }
                error.setSource(this.getClass().getSimpleName());
                rslt = new NotificationResponse();
                rslt.setErrors(Collections.singletonList(error));
            }
            return rslt;
        }
    }

    private final class RequestCallbackImpl
    implements RequestCallback {
        private final Object request;

        public RequestCallbackImpl(Object request) {
            this.request = request;
        }

        public void doWithRequest(ClientHttpRequest httpReq) {
            String password;
            String username;
            if (PortletRequest.class.isInstance(this.request)) {
                PortletRequest portletReq = (PortletRequest)this.request;
                username = RestfulJsonNotificationService.this.usernameEvaluator != null ? RestfulJsonNotificationService.this.usernameEvaluator.evaluate(portletReq) : null;
                password = RestfulJsonNotificationService.this.passwordEvaluator != null ? RestfulJsonNotificationService.this.passwordEvaluator.evaluate(portletReq) : null;
            } else if (HttpServletRequest.class.isInstance(this.request)) {
                HttpServletRequest httpr = (HttpServletRequest)this.request;
                username = RestfulJsonNotificationService.this.usernameEvaluator != null ? RestfulJsonNotificationService.this.usernameEvaluator.evaluate(httpr) : null;
                password = RestfulJsonNotificationService.this.passwordEvaluator != null ? RestfulJsonNotificationService.this.passwordEvaluator.evaluate(httpr) : null;
            } else {
                throw new IllegalStateException("The request is neither a PortletRequest nor an HttpServletRequest");
            }
            if (!StringUtils.isBlank((CharSequence)username) && !StringUtils.isBlank((CharSequence)password)) {
                RestfulJsonNotificationService.this.logger.debug("Preparing ClientHttpRequest for user '{}' (password provided = true)", (Object)username);
                String authString = username.concat(":").concat(password);
                String encodedAuthString = new Base64().encodeToString(authString.getBytes());
                httpReq.getHeaders().add("Authorization", "Basic ".concat(encodedAuthString));
            }
        }
    }
}

