/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rest;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.service.rest.AbstractParameterEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAttributeParameterEvaluator
extends AbstractParameterEvaluator {
    @Resource(name="soffitSignatureKey")
    private String signatureKey;
    private String userAttributeKey;
    private String claimName;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Deprecated
    public void setUserAttributeKey(String userAttributeKey) {
        this.userAttributeKey = userAttributeKey;
    }

    public void setClaimName(String claimName) {
        this.claimName = claimName;
    }

    public String evaluate(PortletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        return (String)userInfo.get(this.userAttributeKey);
    }

    public String evaluate(HttpServletRequest req) {
        Object claimValue;
        String rslt = null;
        Jws oidcToken = this.parseOidcToken(req);
        if (oidcToken != null && (claimValue = ((Claims)oidcToken.getBody()).get((Object)this.claimName)) != null) {
            rslt = claimValue.toString();
        }
        return rslt;
    }

    private Jws<Claims> parseOidcToken(HttpServletRequest req) {
        String authHeader = req.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)authHeader) || !authHeader.startsWith("Bearer ")) {
            return null;
        }
        String bearerToken = authHeader.substring("Bearer ".length());
        try {
            Jws rslt = Jwts.parser().setSigningKey(this.signatureKey).parseClaimsJws(bearerToken);
            this.logger.debug("Found the following OIDC Id token:  {}", (Object)rslt.toString());
            return rslt;
        }
        catch (Exception e) {
            this.logger.info("The following Bearer token is unusable:  '{}'", (Object)bearerToken);
            this.logger.debug("Failed to validate and/or parse the specified Bearer token", (Throwable)e);
            return null;
        }
    }
}

