/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.sort.SortOrder;
import org.jasig.portlet.notice.util.sort.SortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Sorting {
    public static final String SORT_STRATEGY_PARAMETER_NAME = "sort";
    public static final String SORT_ORDER_PARAMETER_NAME = "order";
    @Deprecated
    public static final String SORT_STRATEGY_PREFERENCE = "Sorting.sortStrategy";
    @Deprecated
    public static final String SORT_ORDER_PREFERENCE = "Sorting.sortOrder";
    public static final String SORT_ORDER_DEFAULT = SortOrder.ASCENDING.name();
    private static final Logger LOGGER = LoggerFactory.getLogger(Sorting.class);

    public static NotificationResponse sort(HttpServletRequest req, NotificationResponse data) {
        Comparator comparator = Sorting.chooseConfiguredComparator((HttpServletRequest)req);
        if (comparator == null) {
            return data;
        }
        return Sorting.sortNotificationResponse((Comparator)comparator, (NotificationResponse)data);
    }

    public static List<NotificationEntry> sort(HttpServletRequest req, List<NotificationEntry> entries) {
        Comparator comparator = Sorting.chooseConfiguredComparator((HttpServletRequest)req);
        if (comparator == null) {
            return entries;
        }
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>(entries);
        rslt.sort(comparator);
        return rslt;
    }

    @Deprecated
    public static NotificationResponse sort(PortletRequest req, NotificationResponse data) {
        Comparator comparator = Sorting.chooseConfiguredComparator((PortletRequest)req);
        if (comparator == null) {
            return data;
        }
        return Sorting.sortNotificationResponse((Comparator)comparator, (NotificationResponse)data);
    }

    @Deprecated
    public static List<NotificationEntry> sort(PortletRequest req, List<NotificationEntry> entries) {
        Comparator comparator = Sorting.chooseConfiguredComparator((PortletRequest)req);
        if (comparator == null) {
            return entries;
        }
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>(entries);
        rslt.sort(comparator);
        return rslt;
    }

    private static Comparator<NotificationEntry> chooseConfiguredComparator(HttpServletRequest req) {
        String strategyName = req.getParameter("sort");
        if (strategyName == null) {
            return null;
        }
        try {
            SortStrategy strategy = SortStrategy.valueOf((String)strategyName.toUpperCase());
            String orderName = req.getParameter("order");
            SortOrder order = StringUtils.isNotBlank((CharSequence)orderName) ? SortOrder.valueOf((String)orderName.toUpperCase()) : SortOrder.valueOf((String)SORT_ORDER_DEFAULT);
            return order.equals((Object)SortOrder.ASCENDING) ? strategy.getComparator() : Collections.reverseOrder(strategy.getComparator());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unable to sort based on parameters {}='{}' and {}='{}'", new Object[]{"sort", strategyName, "order", req.getParameter("order")});
            return null;
        }
    }

    @Deprecated
    private static Comparator<NotificationEntry> chooseConfiguredComparator(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String strategyName = prefs.getValue("Sorting.sortStrategy", null);
        if (strategyName == null) {
            return null;
        }
        try {
            SortStrategy strategy = SortStrategy.valueOf((String)strategyName.toUpperCase());
            String orderName = req.getParameter("order");
            SortOrder order = StringUtils.isNotBlank((CharSequence)orderName) ? SortOrder.valueOf((String)orderName.toUpperCase()) : SortOrder.valueOf((String)SORT_ORDER_DEFAULT);
            return order.equals((Object)SortOrder.ASCENDING) ? strategy.getComparator() : Collections.reverseOrder(strategy.getComparator());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unable to sort based on parameters {}='{}' and {}='{}'", new Object[]{"sort", strategyName, "order", req.getParameter("order")});
            return null;
        }
    }

    private static NotificationResponse sortNotificationResponse(Comparator<NotificationEntry> comparator, NotificationResponse data) {
        ArrayList<NotificationCategory> copies = new ArrayList<NotificationCategory>();
        for (NotificationCategory category : data.getCategories()) {
            ArrayList<NotificationEntry> entries = new ArrayList<NotificationEntry>(category.getEntries());
            entries.sort(comparator);
            copies.add(new NotificationCategory(category.getTitle(), entries));
        }
        return new NotificationResponse(copies, data.getErrors());
    }
}

