/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationResult;
import org.jasig.portlet.notice.util.NotificationResponseFlattener;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.jasig.portlet.notice.util.sort.Sorting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@RequestMapping(value={"VIEW"})
public class NotificationLifecycleController {
    public static final String DO_EVENTS_PREFERENCE = "NotificationLifecycleController.doEvents";
    public static final String INVOKE_REDIRECT_PROTOCOL_PREFERENCE = "NotificationLifecycleController.invokeRedirectProtocol";
    public static final String INVOKE_REDIRECT_PORT_PREFERENCE = "NotificationLifecycleController.invokeRedirectPort";
    private static final String SUCCESS_PATH = "/scripts/success.json";
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private UsernameFinder usernameFinder;
    @Autowired
    private NotificationResponseFlattener notificationResponseFlattener;
    @Resource(name="rootNotificationService")
    private INotificationService notificationService;

    @ResourceMapping(value="GET-NOTIFICATIONS-UNCATEGORIZED")
    public ModelAndView getNotificationsUncategorized(ResourceRequest req, @RequestParam(value="refresh", required=false) String doRefresh) throws IOException {
        this.log.debug((Object)("Invoking getNotifications for user:  " + this.usernameFinder.findUsername((PortletRequest)req)));
        NotificationResponse notifications = this.notificationService.fetch((PortletRequest)req);
        if (notifications == null) {
            String msg = "Notifications have not been loaded for user:  " + this.usernameFinder.findUsername((PortletRequest)req);
            throw new IllegalStateException(msg);
        }
        List<NotificationEntry> allEntries = this.notificationResponseFlattener.flatten(notifications);
        allEntries = Sorting.sort((PortletRequest)req, allEntries);
        HashMap<String, List> model = new HashMap<String, List>();
        model.put("feed", allEntries);
        model.put("errors", notifications.getErrors());
        return new ModelAndView("json", model);
    }

    @ActionMapping(params={"action=invokeNotificationService"})
    public void invokeNotificationService(ActionRequest req, ActionResponse res, @RequestParam(value="refresh", required=false) String doRefresh) throws IOException {
        this.notificationService.invoke(req, res, Boolean.parseBoolean(doRefresh));
        PortletPreferences prefs = req.getPreferences();
        boolean doEvents = Boolean.parseBoolean(prefs.getValue(DO_EVENTS_PREFERENCE, "false"));
        if (!doEvents) {
            String redirectUri = this.evaluateRedirectUri(req);
            res.sendRedirect(redirectUri);
        }
    }

    @ActionMapping
    public void invokeUserAction(ActionRequest req, ActionResponse res, @RequestParam(value="notificationId") String notificationId, @RequestParam(value="actionId") String actionId) throws IOException {
        this.notificationService.invoke(req, res, false);
        NotificationResponse notifications = this.notificationService.fetch((PortletRequest)req);
        NotificationAction target = null;
        NotificationEntry entry = notifications.findNotificationEntryById(notificationId);
        if (entry != null) {
            for (NotificationAction action : entry.getAvailableActions()) {
                if (!actionId.equals(action.getId())) continue;
                target = action;
                break;
            }
        }
        if (target != null) {
            target.invoke(req, res);
            this.notificationService.invoke(req, res, true);
        } else {
            String msg = "Target action not found for notificationId='" + notificationId + "' and actionId='" + actionId + "'";
            this.log.warn((Object)msg);
        }
    }

    @EventMapping(value="{https://source.jasig.org/schemas/portlet/notification}NotificationResult")
    public void collectNotifications(EventRequest req, EventResponse res) {
        NotificationResult notificationResult;
        PortletPreferences prefs = req.getPreferences();
        boolean doEvents = Boolean.parseBoolean(prefs.getValue(DO_EVENTS_PREFERENCE, "false"));
        if (!doEvents) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing event={https://source.jasig.org/schemas/portlet/notification}NotificationResult for user='" + this.usernameFinder.findUsername((PortletRequest)req) + "' and windowId=" + req.getWindowID()));
        }
        if ((notificationResult = (NotificationResult)req.getEvent().getValue()) != null && req.getWindowID().equals(notificationResult.getQueryWindowId())) {
            this.notificationService.collect(req, res);
        }
    }

    private String evaluateRedirectUri(ActionRequest req) {
        String rslt = req.getContextPath() + SUCCESS_PATH;
        PortletPreferences prefs = req.getPreferences();
        String protocol = prefs.getValue(INVOKE_REDIRECT_PROTOCOL_PREFERENCE, null);
        if (protocol != null) {
            String portPart = "";
            String port = prefs.getValue(INVOKE_REDIRECT_PORT_PREFERENCE, null);
            if (port != null) {
                portPart = ":" + port;
            }
            rslt = protocol.toLowerCase() + "://" + req.getServerName() + portPart + rslt;
        }
        return rslt;
    }
}

