/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.action.read.MarkAsReadAndRedirectAction;
import org.jasig.portlet.notice.filter.AbstractNotificationServiceFilter;
import org.jasig.portlet.notice.filter.ReadStateAction;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.util.IJpaServices;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReadStateSupportFilter
extends AbstractNotificationServiceFilter {
    public static final String READ_ATTRIBUTE_NAME = "READ";
    public static final String READ_PARAMETER_NAME = "read";
    public static final NotificationAttribute READ_ATTRIBUTE = new NotificationAttribute("READ", Boolean.TRUE.toString());
    public static final NotificationAttribute UNREAD_ATTRIBUTE = new NotificationAttribute("READ", Boolean.FALSE.toString());
    @Autowired
    private UsernameFinder usernameFinder;
    @Autowired
    private IJpaServices jpaServices;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ReadStateSupportFilter() {
        super(0);
    }

    @Override
    public NotificationResponse doFilter(HttpServletRequest request, INotificationServiceFilterChain chain) {
        NotificationResponse response = chain.doFilter();
        String readFilterParameter = request.getParameter(READ_PARAMETER_NAME);
        NotificationResponse rslt = response.cloneIfNotCloned();
        for (NotificationCategory category : rslt.getCategories()) {
            for (NotificationEntry entry2 : category.getEntries()) {
                List currentActions;
                boolean hasReadActionAlready;
                if (StringUtils.isBlank((String)entry2.getId())) continue;
                String username = this.usernameFinder.findUsername(request);
                List<EventDTO> history = this.jpaServices.getHistory(entry2, username);
                this.logger.trace("Found the following history for username='{}' and entryId='{}': {}", new Object[]{username, entry2.getId(), history});
                ArrayList<NotificationAttribute> attributes = new ArrayList<NotificationAttribute>(entry2.getAttributes());
                boolean isRead = history.stream().anyMatch(event -> NotificationState.READ.equals((Object)event.getState()));
                attributes.add(isRead ? READ_ATTRIBUTE : UNREAD_ATTRIBUTE);
                entry2.setAttributes(attributes);
                if (isRead || (hasReadActionAlready = (currentActions = entry2.getAvailableActions()).stream().anyMatch(action -> ReadStateAction.class.isInstance(action)))) continue;
                ArrayList<MarkAsReadAndRedirectAction> replacementList = new ArrayList<MarkAsReadAndRedirectAction>(currentActions);
                replacementList.add(new MarkAsReadAndRedirectAction());
                entry2.setAvailableActions(replacementList);
            }
        }
        if (StringUtils.isNotBlank((String)readFilterParameter)) {
            boolean readFilterValue = Boolean.parseBoolean(readFilterParameter);
            return rslt.filter(entry -> {
                boolean isRead = entry.getAttributes().stream().anyMatch(attribute -> attribute.equals((Object)READ_ATTRIBUTE));
                return isRead == readFilterValue;
            });
        }
        return rslt;
    }
}

