/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util.sort;

import java.util.Comparator;
import java.util.Date;
import org.jasig.portlet.notice.NotificationEntry;

public enum SortStrategy {
    PRIORITY{
        private final Comparator<NotificationEntry> comparator = Comparator.comparingInt(NotificationEntry::getPriority);

        @Override
        public Comparator<NotificationEntry> getComparator() {
            return this.comparator;
        }
    }
    ,
    DUE_DATE{
        private final Comparator<NotificationEntry> comparator = (o1, o2) -> {
            long difference;
            Date o1due = o1.getDueDate();
            Date o2due = o2.getDueDate();
            int rslt = 0;
            if (o1due == null && o2due != null) {
                rslt = -1;
            } else if (o1due != null && o2due == null) {
                rslt = 1;
            } else if (o1due != null && o2due != null && (difference = o1due.getTime() - o2due.getTime()) != 0L) {
                rslt = difference > 0L ? 1 : -1;
            }
            return rslt;
        };

        @Override
        public Comparator<NotificationEntry> getComparator() {
            return this.comparator;
        }
    };


    public abstract Comparator<NotificationEntry> getComparator();
}

