/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.filter.AbstractNotificationServiceFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Component;

@Component
public class ApiUrlSupportFilter
extends AbstractNotificationServiceFilter {
    public static final String AUTHORIZATION_PARAMETER_NAME = "_authorization";
    private static final String REST_API_URL_FORMAT = "%s/api/v2/action/%s/%s?_csrf=%s&_authorization=%s";

    public ApiUrlSupportFilter() {
        super(-100);
    }

    @Override
    public NotificationResponse doFilter(HttpServletRequest request, INotificationServiceFilterChain chain) {
        NotificationResponse response = chain.doFilter();
        NotificationResponse rslt = response.cloneIfNotCloned();
        for (NotificationCategory category : rslt.getCategories()) {
            for (NotificationEntry entry : category.getEntries()) {
                List actions = entry.getAvailableActions().stream().peek(action -> {
                    if (StringUtils.isNotBlank((CharSequence)action.getId()) && action.getTarget() != null && StringUtils.isNotBlank((CharSequence)action.getTarget().getId())) {
                        String requestUrl = request.getRequestURL().toString();
                        String contextPath = request.getContextPath();
                        String urlBase = requestUrl.substring(0, requestUrl.indexOf(contextPath)) + contextPath;
                        CsrfToken csrf = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
                        String apiUrl = String.format(REST_API_URL_FORMAT, urlBase, action.getId(), action.getTarget().getId(), csrf != null ? csrf.getToken() : null, this.getBearerToken(request));
                        action.setApiUrl(apiUrl);
                    }
                }).collect(Collectors.toList());
                entry.setAvailableActions(actions);
            }
        }
        return rslt;
    }

    private String getBearerToken(HttpServletRequest request) {
        String rslt = "";
        String authHeader = request.getHeader("Authorization");
        if (StringUtils.isNotBlank((CharSequence)authHeader) && authHeader.startsWith("Bearer ")) {
            rslt = authHeader.substring("Bearer ".length());
        }
        return rslt;
    }
}

