/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.acknowledge;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.portlet.notice.filter.ReadStateAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgeAction
extends ReadStateAction {
    private static final Logger log = LoggerFactory.getLogger(AcknowledgeAction.class);
    private static final String SESSION_ATTR_PREFIX = AcknowledgeAction.class.getName() + ".";

    public void invoke(ActionRequest req, ActionResponse res) throws IOException {
        log.debug("Calling {} portlet invoke() for notice {}", (Object)AcknowledgeAction.class.getCanonicalName(), (Object)this.getTarget().getId());
        PortletSession session = req.getPortletSession(true);
        session.setAttribute(this.getSessionAttrName(), (Object)System.currentTimeMillis());
    }

    public void invoke(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Calling {} invoke() for notice {}", (Object)AcknowledgeAction.class.getCanonicalName(), (Object)this.getTarget().getId());
        HttpSession session = request.getSession(true);
        session.setAttribute(this.getSessionAttrName(), (Object)System.currentTimeMillis());
    }

    private String getSessionAttrName() {
        assert (this.getTarget() != null);
        return SESSION_ATTR_PREFIX + this.getTarget().getSource() + "." + this.getTarget().getId();
    }

    public boolean isAck(HttpSession session) {
        assert (session != null);
        return session.getAttribute(this.getSessionAttrName()) != null;
    }

    public boolean isAck(PortletSession session) {
        assert (session != null);
        return session.getAttribute(this.getSessionAttrName()) != null;
    }
}

