/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.classloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.classloader.ClassLoaderResourceNotificationService;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class DemoNotificationService
extends ClassLoaderResourceNotificationService {
    private static final String LOCATIONS_PREFERENCE = "DemoNotificationService.locations";
    private static final DateTimeFormatter DATE_PARSER = DateTimeFormat.forPattern((String)"MM/dd/YYYY");
    private static final int MIN_DAY_DELTA = 1;
    private static final int MAX_DAY_DELTA = 14;
    private static final int BLUE_SHIFT = -7;
    @Value(value="${DemoNotificationService.locations:}")
    private String locationsProperty;
    private List<String> locationsList = Collections.emptyList();
    private boolean active = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.locationsProperty)) {
            this.locationsList = Collections.unmodifiableList(Arrays.asList(this.locationsProperty.split(",")));
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public NotificationResponse fetch(PortletRequest req) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        if (this.active) {
            this.log.debug("Sending a non-empty response because we are ACTIVE");
            rslt = super.fetch(req);
            this.updateNotificationResponse(rslt);
        } else {
            this.log.debug("Sending an empty response because we are INACTIVE");
        }
        return rslt;
    }

    public NotificationResponse fetch(HttpServletRequest req) {
        NotificationResponse rslt = NotificationResponse.EMPTY_RESPONSE;
        if (this.active) {
            this.log.debug("Sending a non-empty response because we are ACTIVE");
            rslt = super.fetch(req);
            this.updateNotificationResponse(rslt);
        } else {
            this.log.debug("Sending an empty response because we are INACTIVE");
        }
        return rslt;
    }

    protected List<String> getLocations(HttpServletRequest req) {
        return this.locationsList;
    }

    protected ArrayList<String> getLocations(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] locations = prefs.getValues(LOCATIONS_PREFERENCE, new String[0]);
        return new ArrayList<String>(Arrays.asList(locations));
    }

    private void updateNotificationResponse(NotificationResponse response) {
        int jobDaysAdjustment = (int)new Duration((ReadableInstant)new LocalDate(2014, 5, 15).toDateTimeAtStartOfDay(), (ReadableInstant)new LocalDate().toDateTimeAtStartOfDay()).getStandardDays();
        for (NotificationCategory nc : response.getCategories()) {
            for (NotificationEntry y : nc.getEntries()) {
                if (y.getDueDate() != null) {
                    y.setDueDate(this.generateRandomDueDate());
                }
                this.updateDateAttributeIfPresent(y.getAttributes(), "postDate", jobDaysAdjustment);
                this.updateDateAttributeIfPresent(y.getAttributes(), "dateClosed", jobDaysAdjustment);
                this.updateDateAttributeIfPresent(y.getAttributes(), "startDate", jobDaysAdjustment);
            }
        }
    }

    private Date generateRandomDueDate() {
        int randomDelta = 1 + (int)(Math.random() * 14.0) + -7;
        GregorianCalendar rslt = new GregorianCalendar();
        rslt.setTimeInMillis(System.currentTimeMillis());
        ((Calendar)rslt).add(5, randomDelta);
        return rslt.getTime();
    }

    private void updateDateAttributeIfPresent(List<NotificationAttribute> attributeList, String attributeName, int addDays) {
        for (NotificationAttribute attr : attributeList) {
            if (!attr.getName().equals(attributeName)) continue;
            if (attr.getValues().size() == 1) {
                LocalDate date = DATE_PARSER.parseLocalDate((String)attr.getValues().get(0));
                attr.setValues(Collections.singletonList(DATE_PARSER.print((ReadableInstant)date.plusDays(addDays).toDateTimeAtStartOfDay())));
            } else if (attr.getValues().size() > 1) {
                this.log.warn("Sample data for Notification Attribute {} has {} values; considering only 1st value", (Object)attr.getName(), (Object)attr.getValues().size());
            } else {
                this.log.warn("Sample data for Notification Attribute {} has no values");
            }
            String value = attr.getValues().size() > 0 ? (String)attr.getValues().get(0) : "";
            attr.setValues(Collections.singletonList(value));
        }
    }
}

