/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.jdbc;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.portlet.notice.IRefreshable;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class AbstractJdbcNotificationService
extends AbstractNotificationService
implements IRefreshable {
    @Value(value="${org.apereo.portal.soffit.jwt.signatureKey:CHANGEMEBx0myZ/pv/e7+xrdDLYGC1iIzSa6Uw5CPpH0KCCS1deESk3v+b+LYMz1ks57tjFb9vudpSCyRKXO5TeEBc45rfMyGtkRa1zri+hukZIAfgrvCbFixpCBxBusRs+uhXRuLxOe6k77VE+EMM4jVJArtNBgVPyV7iOC05kHNiYIGgs=}")
    private String signatureKey;
    private DataSource dataSource;
    private String sql;
    private Cache cache;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private Set<String> requiredParameters = Collections.emptySet();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Required
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Resource(name="AbstractJdbcNotificationService.responseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setRequiredParameters(Set<String> requiredParameters) {
        this.requiredParameters = Collections.unmodifiableSet(requiredParameters);
    }

    @PostConstruct
    public void init() {
        String name = this.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalStateException("Notification service name not specified");
        }
        this.logger.debug("Initializing AbstractJdbcNotificationService where name={}", (Object)name);
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
    }

    @Override
    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        String username = this.usernameFinder.findUsername((PortletRequest)req);
        this.logger.debug("Performing AbstractJdbcNotificationService.invoke() for user='{}' refresh={}", (Object)username, (Object)refresh);
        if (refresh) {
            CacheKey cacheKey = new CacheKey(this.getName(), username, this.sql);
            this.cache.remove((Serializable)cacheKey);
        }
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        String username = this.usernameFinder.findUsername(req);
        return this.fetchFromCacheOrSupplier(username, () -> {
            SqlParameterSource sqlParameterSource = this.getSqlParameterSource(req);
            ResultSetExtractor<NotificationResponse> resultSetExtractor = this.getResultSetExtractor(req);
            return this.executeQuery(username, sqlParameterSource, resultSetExtractor);
        });
    }

    @Override
    public NotificationResponse fetch(HttpServletRequest request) {
        String username = this.usernameFinder.findUsername(request);
        return this.fetchFromCacheOrSupplier(username, () -> {
            SqlParameterSource sqlParameterSource = this.getSqlParameterSource(request);
            ResultSetExtractor<NotificationResponse> resultSetExtractor = this.getResultSetExtractor(request);
            return this.executeQuery(username, sqlParameterSource, resultSetExtractor);
        });
    }

    @Override
    public void refresh(HttpServletRequest request, HttpServletResponse response) {
        String username = this.usernameFinder.findUsername(request);
        CacheKey cacheKey = new CacheKey(this.getName(), username, this.sql);
        this.logger.debug("Refreshing/clearing cache for {}", (Object)cacheKey);
        this.cache.remove((Serializable)cacheKey);
    }

    protected SqlParameterSource getSqlParameterSource(PortletRequest req) {
        Map userInfo = (Map)req.getAttribute("javax.portlet.userinfo");
        this.logger.debug("Notification service '{}' prepared the following SQL parametersfor user '{}':  {}", new Object[]{this.getName(), this.usernameFinder.findUsername(req), userInfo});
        return new MapSqlParameterSource(userInfo);
    }

    protected SqlParameterSource getSqlParameterSource(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)authHeader) || !authHeader.startsWith("Bearer ")) {
            return EmptySqlParameterSource.INSTANCE;
        }
        String bearerToken = authHeader.substring("Bearer ".length());
        try {
            Jws claims = Jwts.parser().setSigningKey(this.signatureKey).parseClaimsJws(bearerToken);
            HashMap map = new HashMap();
            ((Claims)claims.getBody()).entrySet().forEach(entry -> {
                Object value = entry.getValue();
                if (List.class.isInstance(value) && ((List)value).size() != 0) {
                    map.put(entry.getKey(), ((List)value).get(0));
                } else {
                    map.put(entry.getKey(), value);
                }
            });
            return new MapSqlParameterSource(map);
        }
        catch (Exception e) {
            this.logger.warn("The specified Bearer token is unusable:  '{}'", (Object)bearerToken);
            this.logger.debug("Failed to validate and/or parse the specified Bearer token", (Throwable)e);
            return EmptySqlParameterSource.INSTANCE;
        }
    }

    protected abstract ResultSetExtractor<NotificationResponse> getResultSetExtractor(PortletRequest var1);

    protected abstract ResultSetExtractor<NotificationResponse> getResultSetExtractor(HttpServletRequest var1);

    public NotificationResponse fetchFromCacheOrSupplier(String username, Supplier<NotificationResponse> supplier) {
        NotificationResponse rslt;
        CacheKey cacheKey = new CacheKey(this.getName(), username, this.sql);
        this.logger.debug("cache ttl = {}", (Object)this.cache.getCacheConfiguration().getTimeToLiveSeconds());
        Element m = this.cache.get((Serializable)cacheKey);
        if (m != null) {
            this.logger.debug("cache hit for {}", (Object)cacheKey);
            rslt = (NotificationResponse)m.getObjectValue();
            this.logger.debug("Found the following response for user='{}' from cache:  {}", (Object)username, (Object)rslt);
        } else {
            this.logger.debug("cache miss for {}", (Object)cacheKey);
            rslt = supplier.get();
            this.cache.put(new Element((Serializable)cacheKey, (Serializable)rslt));
            this.logger.debug("Notification service '{}' generated the following responsefor user='{}':  {}", new Object[]{this.getName(), username, rslt});
        }
        return rslt;
    }

    public NotificationResponse executeQuery(String username, SqlParameterSource sqlParameterSource, ResultSetExtractor<NotificationResponse> resultSetExtractor) {
        boolean hasAllParameters = true;
        for (String parameter : this.requiredParameters) {
            if (sqlParameterSource.hasValue(parameter)) continue;
            this.logger.debug("Skipping notification service='{}' for user='{}' because required parameter '{}' was not present", new Object[]{this.getName(), username, parameter});
            hasAllParameters = false;
            break;
        }
        return hasAllParameters ? (NotificationResponse)this.jdbcTemplate.query(this.sql, sqlParameterSource, resultSetExtractor) : NotificationResponse.EMPTY_RESPONSE;
    }

    private static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String serviceName;
        private final String username;
        private final String sql;

        public CacheKey(String serviceName, String username, String sql) {
            this.serviceName = serviceName;
            this.username = username;
            this.sql = sql;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("serviceName", (Object)this.serviceName).append("username", (Object)this.username).append("sql", (Object)this.sql).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return new EqualsBuilder().append((Object)this.serviceName, (Object)cacheKey.serviceName).append((Object)this.username, (Object)cacheKey.username).append((Object)this.sql, (Object)cacheKey.sql).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.serviceName).append((Object)this.username).append((Object)this.sql).toHashCode();
        }
    }
}

