/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.util.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.sort.SortOrder;
import org.jasig.portlet.notice.util.sort.SortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sorting {
    public static final String SORT_STRATEGY_PARAMETER_NAME = "sort";
    public static final String SORT_ORDER_PARAMETER_NAME = "order";
    @Deprecated
    public static final String SORT_STRATEGY_PREFERENCE = "Sorting.sortStrategy";
    @Deprecated
    public static final String SORT_ORDER_PREFERENCE = "Sorting.sortOrder";
    public static final String SORT_ORDER_DEFAULT = SortOrder.ASCENDING.name();
    private static final Logger LOGGER = LoggerFactory.getLogger(Sorting.class);

    public static NotificationResponse sort(HttpServletRequest req, NotificationResponse data) {
        Comparator<NotificationEntry> comparator = Sorting.chooseConfiguredComparator(req);
        if (comparator == null) {
            return data;
        }
        return Sorting.sortNotificationResponse(comparator, data);
    }

    public static List<NotificationEntry> sort(HttpServletRequest req, List<NotificationEntry> entries) {
        Comparator<NotificationEntry> comparator = Sorting.chooseConfiguredComparator(req);
        if (comparator == null) {
            return entries;
        }
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>(entries);
        rslt.sort(comparator);
        return rslt;
    }

    @Deprecated
    public static NotificationResponse sort(PortletRequest req, NotificationResponse data) {
        Comparator<NotificationEntry> comparator = Sorting.chooseConfiguredComparator(req);
        if (comparator == null) {
            return data;
        }
        return Sorting.sortNotificationResponse(comparator, data);
    }

    @Deprecated
    public static List<NotificationEntry> sort(PortletRequest req, List<NotificationEntry> entries) {
        Comparator<NotificationEntry> comparator = Sorting.chooseConfiguredComparator(req);
        if (comparator == null) {
            return entries;
        }
        ArrayList<NotificationEntry> rslt = new ArrayList<NotificationEntry>(entries);
        rslt.sort(comparator);
        return rslt;
    }

    private static Comparator<NotificationEntry> chooseConfiguredComparator(HttpServletRequest req) {
        String strategyName = req.getParameter(SORT_STRATEGY_PARAMETER_NAME);
        if (strategyName == null) {
            return null;
        }
        try {
            SortStrategy strategy = SortStrategy.valueOf(strategyName.toUpperCase());
            String orderName = req.getParameter(SORT_ORDER_PARAMETER_NAME);
            SortOrder order = StringUtils.isNotBlank((CharSequence)orderName) ? SortOrder.valueOf(orderName.toUpperCase()) : SortOrder.valueOf(SORT_ORDER_DEFAULT);
            return order.equals((Object)SortOrder.ASCENDING) ? strategy.getComparator() : Collections.reverseOrder(strategy.getComparator());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unable to sort based on parameters {}='{}' and {}='{}'", new Object[]{SORT_STRATEGY_PARAMETER_NAME, strategyName, SORT_ORDER_PARAMETER_NAME, req.getParameter(SORT_ORDER_PARAMETER_NAME)});
            return null;
        }
    }

    @Deprecated
    private static Comparator<NotificationEntry> chooseConfiguredComparator(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String strategyName = prefs.getValue(SORT_STRATEGY_PREFERENCE, null);
        if (strategyName == null) {
            return null;
        }
        try {
            SortStrategy strategy = SortStrategy.valueOf(strategyName.toUpperCase());
            String orderName = req.getParameter(SORT_ORDER_PARAMETER_NAME);
            SortOrder order = StringUtils.isNotBlank((CharSequence)orderName) ? SortOrder.valueOf(orderName.toUpperCase()) : SortOrder.valueOf(SORT_ORDER_DEFAULT);
            return order.equals((Object)SortOrder.ASCENDING) ? strategy.getComparator() : Collections.reverseOrder(strategy.getComparator());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Unable to sort based on parameters {}='{}' and {}='{}'", new Object[]{SORT_STRATEGY_PARAMETER_NAME, strategyName, SORT_ORDER_PARAMETER_NAME, req.getParameter(SORT_ORDER_PARAMETER_NAME)});
            return null;
        }
    }

    private static NotificationResponse sortNotificationResponse(Comparator<NotificationEntry> comparator, NotificationResponse data) {
        ArrayList<NotificationCategory> copies = new ArrayList<NotificationCategory>();
        for (NotificationCategory category : data.getCategories()) {
            ArrayList<NotificationEntry> entries = new ArrayList<NotificationEntry>(category.getEntries());
            entries.sort(comparator);
            copies.add(new NotificationCategory(category.getTitle(), entries));
        }
        return new NotificationResponse(copies, data.getErrors());
    }
}

