/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.action.read;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.filter.ReadStateAction;
import org.jasig.portlet.notice.rest.EventDTO;
import org.jasig.portlet.notice.util.JpaServices;
import org.jasig.portlet.notice.util.SpringContext;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAction
extends ReadStateAction {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = LoggerFactory.getLogger(ReadAction.class);
    public static final ReadAction READ = new ReadAction();
    private static final String READ_NOTIFICATION_IDS_PREFERENCE = ReadAction.class.getName() + ".READ_NOTIFICATION_IDS_PREFERENCE";

    public ReadAction() {
        this.setLabel("MARK AS READ");
    }

    public ReadAction(String label) {
        this.setLabel(label);
    }

    public static final ReadAction createReadInstance() {
        return new ReadAction();
    }

    public static final ReadAction createUnReadInstance() {
        return new ReadAction("MARK AS UNREAD");
    }

    public void invoke(ActionRequest req, ActionResponse res) throws IOException {
        NotificationEntry entry = this.getTarget();
        String notificationId = entry.getId();
        Set readNotices = this.getReadNotices((PortletRequest)req);
        if (readNotices.contains(notificationId)) {
            readNotices.remove(notificationId);
        } else {
            readNotices.add(notificationId);
        }
        this.setReadNotices((PortletRequest)req, readNotices);
    }

    public void invoke(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String username;
        NotificationEntry entry = this.getTarget();
        if (!this.isRead(entry, username = ((UsernameFinder)SpringContext.getApplicationContext().getBean("usernameFinder")).findUsername(request))) {
            JpaServices jpaServices = (JpaServices)SpringContext.getApplicationContext().getBean("jpaServices");
            jpaServices.applyState(entry, username, NotificationState.READ);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)super.getId()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public void removeReadNotices(PortletRequest req, Set<String> idsToRemove) {
        Set currentIds = this.getReadNotices(req);
        currentIds.removeAll(idsToRemove);
        this.setReadNotices(req, currentIds);
    }

    Set<String> getReadNotices(PortletRequest req) {
        HashSet<String> rslt = new HashSet<String>();
        PortletPreferences prefs = req.getPreferences();
        String[] ids = prefs.getValues(READ_NOTIFICATION_IDS_PREFERENCE, new String[0]);
        for (int i = 0; i < ids.length; ++i) {
            rslt.add(ids[i]);
        }
        return rslt;
    }

    void setReadNotices(PortletRequest req, Set<String> favoriteNotices) {
        String[] ids = favoriteNotices.toArray(new String[favoriteNotices.size()]);
        PortletPreferences prefs = req.getPreferences();
        try {
            prefs.setValues(READ_NOTIFICATION_IDS_PREFERENCE, ids);
            prefs.store();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isRead(NotificationEntry entry, String username) {
        JpaServices jpaServices = (JpaServices)SpringContext.getApplicationContext().getBean("jpaServices");
        List history = jpaServices.getHistory(entry, username);
        boolean rslt = false;
        for (EventDTO event : history) {
            if (!NotificationState.READ.equals((Object)event.getState())) continue;
            logger.debug("Found a READ event:  {}", (Object)event);
            rslt = true;
            break;
        }
        return rslt;
    }
}

