/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.filter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.service.filter.INotificationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequiredRoleNotificationFilter
implements INotificationFilter {
    public static final String REQUIRED_ROLE_ATTRIBUTE_NAME = RequiredRoleNotificationFilter.class.getName() + ".requiredRole";
    private final Set<String> userRolesLowerCase;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public RequiredRoleNotificationFilter(Set<String> userRoles) {
        this.userRolesLowerCase = userRoles.stream().map(role -> role.toLowerCase()).collect(Collectors.toSet());
    }

    @Override
    public boolean doFilter(NotificationCategory category, NotificationEntry entry) {
        List requiredRoleValues = (List)entry.getAttributesMap().get(REQUIRED_ROLE_ATTRIBUTE_NAME);
        if (requiredRoleValues == null || requiredRoleValues.size() == 0) {
            return true;
        }
        boolean rslt = requiredRoleValues.stream().anyMatch(role -> this.userRolesLowerCase.contains(role.toLowerCase()));
        this.logger.debug("Filtering entry '{}'... requiredRoleValues='{}', userRolesLowerCase='{}', decision='{}'", new Object[]{entry.getTitle(), requiredRoleValues, this.userRolesLowerCase, rslt});
        return rslt;
    }
}

