/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.rome;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationAttribute;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationError;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.rome.TimestampNotificationEntry;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;

public final class RomeNotificationService
extends AbstractNotificationService {
    private static final String URLS_PREFERENCE = "RomeNotificationService.urls";
    private static final Locale locale = Locale.getDefault(Locale.Category.FORMAT);
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3, locale);
    @Autowired
    private MessageSource messages;
    @Value(value="${RomeNotificationService.feedUrls:}")
    private String feedUrlsProperty;
    private List<String> feedUrlsList = Collections.emptyList();
    private Cache cache;
    @Autowired
    private UsernameFinder usernameFinder;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Resource(name="RomeNotificationService.feedCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.feedUrlsProperty)) {
            this.feedUrlsList = Collections.unmodifiableList(Arrays.asList(this.feedUrlsProperty.split(",")));
        }
    }

    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Performing RomeNotificationService.invoke() for user='" + this.usernameFinder.findUsername((PortletRequest)req) + "' refresh=" + refresh);
        }
        if (refresh) {
            String[] urls;
            PortletPreferences prefs = req.getPreferences();
            for (String item : urls = prefs.getValues(URLS_PREFERENCE, new String[0])) {
                this.cache.remove((Serializable)((Object)item));
            }
        }
    }

    public NotificationResponse fetch(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] feedUrls = prefs.getValues(URLS_PREFERENCE, new String[0]);
        String username = this.usernameFinder.findUsername(req);
        return this.doFetch(Arrays.asList(feedUrls), username);
    }

    public NotificationResponse fetch(HttpServletRequest req) {
        String username = this.usernameFinder.findUsername(req);
        return this.doFetch(this.feedUrlsList, username);
    }

    private NotificationResponse doFetch(List<String> feedUrls, String username) {
        ArrayList<NotificationCategory> categories = new ArrayList<NotificationCategory>();
        ArrayList<NotificationError> errors = new ArrayList<NotificationError>();
        for (String item : feedUrls) {
            NotificationCategory category;
            Element m = this.cache.get((Serializable)((Object)item));
            if (m != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Feed cache HIT for url:  " + item);
                }
                category = (NotificationCategory)m.getObjectValue();
                categories.add(category);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Feed cache MISS for url:  " + item);
                this.logger.debug("Checking the following feed URL for notifications for user '" + username + "' -- " + item);
            }
            if ((category = this.fetchFromSourceUrl(item)) != null) {
                this.cache.put(new Element((Serializable)((Object)item), (Serializable)category));
                categories.add(category);
                continue;
            }
            NotificationError error = new NotificationError();
            error.setError("Service Unavailable");
            error.setSource(this.getName());
            errors.add(error);
        }
        NotificationResponse rslt = new NotificationResponse();
        rslt.setCategories(categories);
        rslt.setErrors(errors);
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationCategory fetchFromSourceUrl(String url) {
        String msg;
        NotificationCategory rslt = null;
        XmlReader reader = null;
        try {
            URL u = new URL(url);
            reader = new XmlReader(u);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)reader);
            rslt = new NotificationCategory();
            rslt.setTitle(feed.getTitle());
            ArrayList<TimestampNotificationEntry> entries = new ArrayList<TimestampNotificationEntry>();
            List list = feed.getEntries();
            for (SyndEntry y : list) {
                Date updatededDate;
                Date publishedDate;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Processing SyndEntry:  \n" + y.toString());
                }
                long timestamp = y.getPublishedDate().getTime();
                TimestampNotificationEntry entry = new TimestampNotificationEntry(timestamp);
                entry.setSource(feed.getAuthor());
                entry.setTitle(y.getTitle());
                entry.setUrl(y.getLink());
                StringBuilder body = new StringBuilder();
                SyndContent desc = y.getDescription();
                if (desc != null) {
                    body.append(desc.getValue());
                }
                if (body.length() == 0) {
                    List contents = y.getContents();
                    for (SyndContent c : contents) {
                        body.append(c.getValue());
                    }
                }
                if (body.length() == 0) {
                    String noInfo = this.messages.getMessage("notice.noinfo", null, locale);
                    body.append(noInfo);
                }
                entry.setBody(body.toString());
                ArrayList<NotificationAttribute> attributes = new ArrayList<NotificationAttribute>();
                String author = y.getAuthor();
                if (StringUtils.isNotBlank((CharSequence)author)) {
                    String authorLabel = this.messages.getMessage("notice.author", null, locale);
                    attributes.add(new NotificationAttribute(authorLabel, author));
                }
                if ((publishedDate = y.getPublishedDate()) != null) {
                    String dateLabel = this.messages.getMessage("notice.date.published", null, locale);
                    attributes.add(new NotificationAttribute(dateLabel, DATE_FORMAT.format(publishedDate)));
                }
                if ((updatededDate = y.getUpdatedDate()) != null) {
                    String dateLabel = this.messages.getMessage("notice.date.updated", null, locale);
                    attributes.add(new NotificationAttribute(dateLabel, DATE_FORMAT.format(updatededDate)));
                }
                entry.setAttributes(attributes);
                entries.add(entry);
            }
            Collections.sort(entries);
            Collections.reverse(entries);
            rslt.setEntries(new ArrayList(entries));
        }
        catch (Exception e) {
            msg = "Unable to read the specified feed:  " + url;
            this.logger.error(msg, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    msg = "Unable to close the XmlReader";
                    this.logger.error("Unable to close the XmlReader", (Throwable)ioe);
                }
            }
        }
        return rslt;
    }
}

