/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.portlet.notice.INotificationService;
import org.jasig.portlet.notice.IRefreshable;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.jasig.portlet.notice.service.filter.FilteringNotificationServiceDecorator;
import org.jasig.portlet.notice.service.jdbc.AbstractJdbcNotificationService;
import org.jasig.portlet.notice.util.PortletXmlRoleService;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;

public final class CacheNotificationService
extends AbstractNotificationService
implements IRefreshable {
    private ApplicationContext applicationContext;
    private List<INotificationService> embeddedServices;
    private Cache cache;
    private boolean useDiscoverable = true;
    private final Map<String, INotificationService> servicesMap = new HashMap<String, INotificationService>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired(required=false)
    public void setUseDiscoverable(String useDisc) {
        this.useDiscoverable = Boolean.valueOf(useDisc);
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Required
    public void setEmbeddedServices(List<INotificationService> embeddedServices) {
        this.embeddedServices = embeddedServices;
    }

    @Resource(name="notificationResponseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @PostConstruct
    public void init() {
        Map discoverableServices;
        this.servicesMap.clear();
        this.logger.info("Configuring CacheNotificationService with name='{}'", (Object)this.getName());
        for (INotificationService s : this.embeddedServices) {
            if (this.servicesMap.containsKey(s.getName())) {
                String msg = "Notification services names must be unique;  duplicate detected for name:  " + s.getName();
                throw new IllegalArgumentException(msg);
            }
            this.servicesMap.put(s.getName(), s);
            this.logger.info("Added configured Notification Service:  {}", (Object)s.getName());
        }
        if (this.useDiscoverable && (discoverableServices = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, AbstractJdbcNotificationService.class)).size() != 0) {
            UsernameFinder usernameFinder = (UsernameFinder)this.applicationContext.getBean("usernameFinder");
            PortletXmlRoleService portletXmlRoleService = (PortletXmlRoleService)this.applicationContext.getBean("portletXmlRoleService");
            for (AbstractJdbcNotificationService s : discoverableServices.values()) {
                FilteringNotificationServiceDecorator decorator = new FilteringNotificationServiceDecorator();
                decorator.setEnclosedNotificationService(s);
                decorator.setUsernameFinder(usernameFinder);
                decorator.setPortletXmlRoleService(portletXmlRoleService);
                this.servicesMap.put(decorator.getName(), decorator);
                this.logger.info("Added discovered Notification Service:  {}", (Object)s.getName());
            }
        }
    }

    @Override
    public void invoke(ActionRequest req, ActionResponse res, boolean refresh) {
        this.logger.trace("Processing invoke() for user '{}' refresh={}", (Object)this.usernameFinder.findUsername((PortletRequest)req), (Object)refresh);
        if (refresh) {
            String cacheKey = this.createServiceUserWindowSpecificCacheKey((PortletRequest)req);
            this.cache.remove((Serializable)((Object)cacheKey));
        }
        for (INotificationService service : this.servicesMap.values()) {
            service.invoke(req, res, refresh);
        }
    }

    @Override
    public void collect(EventRequest req, EventResponse res) {
        for (INotificationService service : this.servicesMap.values()) {
            service.collect(req, res);
        }
    }

    @Override
    public NotificationResponse fetch(PortletRequest req) {
        CacheTuple tuple;
        String username = this.usernameFinder.findUsername(req);
        this.logger.debug("Notifications requested for user='{}' and windowId={}", (Object)username, (Object)req.getWindowID());
        String cacheKey = this.createServiceUserWindowSpecificCacheKey(req);
        Element m = this.cache.get((Serializable)((Object)cacheKey));
        if (m != null) {
            this.logger.debug("Cache HIT for user='{}' and windowId={}", (Object)username, (Object)req.getWindowID());
            tuple = (CacheTuple)m.getObjectValue();
            HashMap<String, NotificationResponse> iterable = new HashMap<String, NotificationResponse>(tuple.getResponses());
            for (Map.Entry entry : iterable.entrySet()) {
                INotificationService service = this.servicesMap.get(entry.getKey());
                if (service == null) {
                    this.logger.warn("Unmatched NotificationResponse in CacheTuple;  service.name()='{}' and user='{}'", entry.getKey(), (Object)username);
                    tuple.getResponses().remove(entry.getKey());
                    continue;
                }
                if (service.isValid(req, (NotificationResponse)entry.getValue())) continue;
                NotificationResponse freshResponse = this.getResponseFromService(req, service);
                tuple.getResponses().put((String)entry.getKey(), freshResponse);
            }
        } else {
            this.logger.debug("Cache MISS for user='{}' and windowId={}", (Object)username, (Object)req.getWindowID());
            tuple = new CacheTuple();
            for (INotificationService service : this.servicesMap.values()) {
                NotificationResponse notificationResponse = this.getResponseFromService(req, service);
                tuple.getResponses().put(service.getName(), notificationResponse);
            }
            this.cache.put(new Element((Object)cacheKey, (Object)tuple));
        }
        NotificationResponse rslt = new NotificationResponse();
        for (Map.Entry<Object, Object> entry : tuple.getResponses().entrySet()) {
            rslt = rslt.combine((NotificationResponse)entry.getValue());
        }
        return rslt;
    }

    private NotificationResponse getResponseFromService(PortletRequest req, INotificationService service) {
        NotificationResponse rslt;
        try {
            rslt = service.fetch(req);
        }
        catch (Exception e) {
            String msg = "Failed to invoke the specified service:  " + service.getName();
            this.logger.error(msg, (Throwable)e);
            rslt = this.prepareErrorResponse(this.getName(), msg);
        }
        return rslt;
    }

    @Override
    public void refresh(HttpServletRequest request, HttpServletResponse response) {
        for (INotificationService service : this.embeddedServices) {
            if (!IRefreshable.class.isInstance(service)) continue;
            this.logger.debug("Refreshing INotificationService bean '{}'", (Object)service.getName());
            ((IRefreshable)((Object)service)).refresh(request, response);
        }
        this.cache.removeAll();
    }

    private static final class CacheTuple {
        private final Map<String, NotificationResponse> responses = new HashMap<String, NotificationResponse>();

        private CacheTuple() {
        }

        public Map<String, NotificationResponse> getResponses() {
            return this.responses;
        }
    }
}

