/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.NotificationState;
import org.jasig.portlet.notice.filter.AbstractNotificationServiceFilter;
import org.jasig.portlet.notice.filter.ReadStateAction;
import org.jasig.portlet.notice.util.IJpaServices;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReadActionFilter
extends AbstractNotificationServiceFilter {
    public static final String READ_ATTRIBUTE_NAME = "READ";
    @Autowired
    private UsernameFinder usernameFinder;
    @Autowired
    private IJpaServices jpaServices;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ReadActionFilter() {
        super(Integer.MIN_VALUE);
    }

    public NotificationResponse doFilter(HttpServletRequest request, INotificationServiceFilterChain chain) {
        NotificationResponse response = chain.doFilter();
        NotificationResponse rslt = response.cloneIfNotCloned();
        for (NotificationCategory category : rslt.getCategories()) {
            for (NotificationEntry entry : category.getEntries()) {
                if (StringUtils.isBlank((String)entry.getId())) continue;
                String username = this.usernameFinder.findUsername(request);
                List history = this.jpaServices.getHistory(entry, username);
                this.logger.trace("Found the following history for username='{}' and entryId='{}': {}", new Object[]{username, entry.getId(), history});
                ArrayList attributes = new ArrayList(entry.getAttributes());
                boolean isRead = history.stream().anyMatch(event -> NotificationState.READ.equals((Object)event.getState()));
                if (!isRead) continue;
                List filteredActions = entry.getAvailableActions().stream().filter(action -> !ReadStateAction.class.isInstance(action)).collect(Collectors.toList());
                entry.setAvailableActions(filteredActions);
            }
        }
        return rslt;
    }
}

