/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.portlet.notice.INotificationServiceFilterChain;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationCategory;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.action.acknowledge.AcknowledgeAction;
import org.jasig.portlet.notice.filter.AbstractNotificationServiceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AcknowledgePerSessionFilter
extends AbstractNotificationServiceFilter {
    private static final Logger log = LoggerFactory.getLogger(AcknowledgePerSessionFilter.class);
    private static final String REQ_ACK_PARAM = "ack";

    public AcknowledgePerSessionFilter() {
        super(10);
    }

    @Override
    public NotificationResponse doFilter(HttpServletRequest request, INotificationServiceFilterChain chain) {
        log.debug("{}.doFilter called", (Object)AcknowledgePerSessionFilter.class.getCanonicalName());
        String ackParameter = request.getParameter(REQ_ACK_PARAM);
        HttpSession session = request.getSession(true);
        log.debug("session id = {}", (Object)session.getId());
        NotificationResponse response = chain.doFilter().cloneIfNotCloned();
        log.debug("response = {}", (Object)response);
        if (ackParameter == null) {
            log.debug("{} was not found in the parameter list", (Object)REQ_ACK_PARAM);
            return this.removeAckActionsWhenAck(response, session);
        }
        boolean filterAck = Boolean.parseBoolean(ackParameter);
        log.debug("{} parsed to {} in request", (Object)REQ_ACK_PARAM, (Object)filterAck);
        for (NotificationCategory category : response.getCategories()) {
            ArrayList<NotificationEntry> newEntries = new ArrayList<NotificationEntry>();
            for (NotificationEntry entry : category.getEntries()) {
                log.debug("entry: {}", (Object)entry);
                List currentActions = entry.getAvailableActions();
                Optional<NotificationAction> acknowledgeActionOptional = currentActions.stream().filter(AcknowledgeAction.class::isInstance).findFirst();
                AcknowledgeAction ackAction = acknowledgeActionOptional.orElse(null);
                assert (ackAction == null || entry.equals(ackAction.getTarget()));
                boolean isAck = ackAction.isAck(session);
                log.debug("{} acknowledge state = {}", (Object)entry.getId(), (Object)isAck);
                if (filterAck && isAck) {
                    log.debug("entry {} ack and {}=true", (Object)entry.getId(), (Object)REQ_ACK_PARAM);
                    newEntries.add(entry);
                    continue;
                }
                if (!(filterAck || ackAction != null && isAck)) {
                    log.debug("entry {} not ack and {}=false", (Object)entry.getId(), (Object)REQ_ACK_PARAM);
                    newEntries.add(entry);
                    continue;
                }
                log.debug("entry {} not selected when {}={} ... removed", new Object[]{entry.getId(), REQ_ACK_PARAM, filterAck});
            }
            category.setEntries(newEntries);
        }
        return this.removeAckActionsWhenAck(response, session);
    }

    private NotificationResponse removeAckActionsWhenAck(NotificationResponse resp, HttpSession session) {
        for (NotificationCategory category : resp.getCategories()) {
            for (NotificationEntry entry : category.getEntries()) {
                log.debug("entry {} actions filtered", (Object)entry.getId());
                List list = entry.getAvailableActions().stream().filter(a -> !AcknowledgeAction.class.isInstance(a) || !((AcknowledgeAction)((Object)a)).isAck(session)).collect(Collectors.toList());
                entry.setAvailableActions(list);
            }
        }
        log.debug("updated response = {}", (Object)resp);
        return resp;
    }
}

