/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.security;

import javax.servlet.Filter;
import org.apereo.portal.soffit.security.SoffitApiAuthenticationManager;
import org.apereo.portal.soffit.security.SoffitApiPreAuthenticatedProcessingFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.support.ErrorPageFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final String PORTAL_ADMINISTRATORS_AUTHORITY = "Portal Administrators";
    @Value(value="${org.apereo.portal.soffit.jwt.signatureKey:CHANGEMEBx0myZ/pv/e7+xrdDLYGC1iIzSa6Uw5CPpH0KCCS1deESk3v+b+LYMz1ks57tjFb9vudpSCyRKXO5TeEBc45rfMyGtkRa1zri+hukZIAfgrvCbFixpCBxBusRs+uhXRuLxOe6k77VE+EMM4jVJArtNBgVPyV7iOC05kHNiYIGgs=}")
    private String signatureKey;
    @Value(value="${security.restV1ReadAuthority:Portal Administrators}")
    private String restV1ReadAuthority;
    @Value(value="${security.restV1WriteAuthority:Portal Administrators}")
    private String restV1WriteAuthority;

    public void configure(WebSecurity web) throws Exception {
        AntPathRequestMatcher pathMatcher = new AntPathRequestMatcher("/api/**");
        NegatedRequestMatcher inverseMatcher = new NegatedRequestMatcher((RequestMatcher)pathMatcher);
        web.ignoring().requestMatchers(new RequestMatcher[]{inverseMatcher});
    }

    protected void configure(HttpSecurity http) throws Exception {
        SoffitApiPreAuthenticatedProcessingFilter filter = new SoffitApiPreAuthenticatedProcessingFilter(this.signatureKey);
        filter.setAuthenticationManager(this.authenticationManager());
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.addFilter((Filter)filter).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/api/v1/**"})).access("hasAuthority('" + this.restV1ReadAuthority + "') or hasAuthority('" + this.restV1WriteAuthority + "')").antMatchers(HttpMethod.POST, new String[]{"/api/v1/**"})).hasAuthority(this.restV1WriteAuthority).antMatchers(HttpMethod.DELETE, new String[]{"/api/v1/**"})).denyAll().antMatchers(HttpMethod.PUT, new String[]{"/api/v1/**"})).denyAll().antMatchers(HttpMethod.GET, new String[]{"/api/v2/**"})).authenticated().antMatchers(HttpMethod.POST, new String[]{"/api/v2/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{"/api/v2/**"})).denyAll().antMatchers(HttpMethod.PUT, new String[]{"/api/v2/**"})).denyAll().anyRequest()).permitAll().and()).sessionManagement().sessionFixation().none().and()).csrf().ignoringAntMatchers(new String[]{"/api/v1/**"}).ignoringAntMatchers(new String[]{"/api/v2/**"});
    }

    @Bean
    public AuthenticationManager authenticationManager() {
        return new SoffitApiAuthenticationManager();
    }

    @Bean
    public ErrorPageFilter errorPageFilter() {
        return new ErrorPageFilter();
    }

    @Bean
    public FilterRegistrationBean disableSpringBootErrorFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)this.errorPageFilter());
        filterRegistrationBean.setEnabled(false);
        return filterRegistrationBean;
    }

    @Bean(value={"soffitSignatureKey"})
    public String signatureKey() {
        return this.signatureKey;
    }
}

