/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice;

import io.swagger.models.auth.In;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration {
    private static final String API_KEY_NAME = "api_key";

    @Bean
    public Docket docket() {
        return new Docket(DocumentationType.SWAGGER_2).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext()));
    }

    private ApiKey apiKey() {
        return new ApiKey(API_KEY_NAME, "Authorization", In.HEADER.name());
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(Collections.singletonList(this.securityReference())).forPaths(PathSelectors.regex((String)"/api.*")).build();
    }

    private SecurityReference securityReference() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "Access REST APIs");
        return new SecurityReference(API_KEY_NAME, new AuthorizationScope[]{authorizationScope});
    }
}

