/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.controller.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portlet.notice.INotificationRepository;
import org.jasig.portlet.notice.NotificationAction;
import org.jasig.portlet.notice.NotificationEntry;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.util.NotificationResponseFlattener;
import org.jasig.portlet.notice.util.UsernameFinder;
import org.jasig.portlet.notice.util.sort.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2"})
public class NotificationRestV2Controller {
    public static final String API_ROOT = "/api/v2";
    @Autowired
    private INotificationRepository repository;
    @Autowired
    private NotificationResponseFlattener notificationResponseFlattener;
    @Autowired
    private UsernameFinder usernameFinder;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/notifications"}, method={RequestMethod.GET})
    public List<NotificationEntry> fetchNotifications(HttpServletRequest request) {
        NotificationResponse response = this.repository.fetch(request);
        List<NotificationEntry> rslt = this.notificationResponseFlattener.flatten(response);
        this.logger.debug("result count = {}", (Object)rslt.size());
        this.logger.debug("result = {}", rslt);
        return Sorting.sort(request, rslt);
    }

    @RequestMapping(value={"/action/{actionId}/{notificationId}"}, method={RequestMethod.POST})
    public Map<String, Object> invokeAction(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="actionId") String actionId, @PathVariable(value="notificationId") String notificationId) {
        HttpServletRequest decoratedRequest = this.decorateWithAuthorizationIfPresent(request);
        NotificationResponse notifications = this.repository.fetch(decoratedRequest);
        NotificationAction target = null;
        NotificationEntry entry = notifications.findNotificationEntryById(notificationId);
        if (entry != null) {
            for (NotificationAction a : entry.getAvailableActions()) {
                if (!actionId.equals(a.getId())) continue;
                target = a;
                break;
            }
        } else {
            this.logger.warn("Notification not found for notificationId='{}'", (Object)notificationId);
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        if (target != null) {
            try {
                target.invoke(decoratedRequest, response);
            }
            catch (IOException e) {
                String username = this.usernameFinder.findUsername(decoratedRequest);
                this.logger.error("Failed to invoke action '{}' on entry '{}' for user '{}'", new Object[]{target.getLabel(), entry.getId(), username, e});
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                return null;
            }
        } else {
            this.logger.warn("Target action not found for notificationId='{}' and actionId='{}'", (Object)notificationId, (Object)actionId);
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        this.repository.refresh(decoratedRequest, response);
        return Collections.singletonMap("success", true);
    }

    private HttpServletRequest decorateWithAuthorizationIfPresent(final HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name) && request.getParameterMap().containsKey("_authorization")) {
                    return "Bearer " + request.getParameter("_authorization");
                }
                return super.getHeader(name);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name) && request.getParameterMap().containsKey("_authorization")) {
                    return Collections.enumeration(Collections.singletonList("Bearer " + request.getParameter("_authorization")));
                }
                return super.getHeaders(name);
            }

            public Enumeration<String> getHeaderNames() {
                if (request.getParameterMap().containsKey("_authorization")) {
                    Vector<String> vector = new Vector<String>(Collections.list(this.getHeaderNames()));
                    vector.add("Authorization");
                    return vector.elements();
                }
                return super.getHeaderNames();
            }
        };
    }
}

