/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.notice.service.classloader;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.StringUtils;
import org.jasig.portlet.notice.NotificationResponse;
import org.jasig.portlet.notice.service.AbstractNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ClassLoaderResourceNotificationService
extends AbstractNotificationService {
    public static final String LOCATIONS_PREFERENCE = "ClassLoaderResourceNotificationService.locations";
    @Value(value="${ClassLoaderResourceNotificationService.locations:}")
    private String locationsProperty;
    private List<String> locationsList = Collections.emptyList();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Cache cache;

    @Resource(name="ClassLoaderResourceNotificationService.responseCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((CharSequence)this.locationsProperty)) {
            this.locationsList = Collections.unmodifiableList(Arrays.asList(this.locationsProperty.split(",")));
        }
    }

    public NotificationResponse fetch(PortletRequest req) {
        List locations = this.getLocations(req);
        return this.fetchFromClasspath(locations);
    }

    public final boolean isValid(PortletRequest req, NotificationResponse previousResponse) {
        return false;
    }

    public NotificationResponse fetch(HttpServletRequest request) {
        List locations = this.getLocations(request);
        return this.fetchFromClasspath(locations);
    }

    private NotificationResponse fetchFromClasspath(List<String> locations) {
        NotificationResponse rslt;
        if (locations.isEmpty()) {
            return NotificationResponse.EMPTY_RESPONSE;
        }
        Element m = this.cache.get(locations);
        if (m != null) {
            rslt = (NotificationResponse)m.getObjectValue();
            this.logger.debug("Locations cache HIT for collection {};  size={}", locations, (Object)rslt.size());
        } else {
            rslt = new NotificationResponse();
            for (String loc : locations) {
                NotificationResponse response = this.readFromFile(loc);
                rslt = rslt.combine(response);
            }
            this.logger.debug("Locations cache MISS for collection {};  size={}", locations, (Object)rslt.size());
            this.cache.put(new Element(locations, (Object)rslt));
        }
        return rslt;
    }

    @Deprecated
    protected List<String> getLocations(PortletRequest req) {
        PortletPreferences prefs = req.getPreferences();
        String[] locations = prefs.getValues(LOCATIONS_PREFERENCE, new String[0]);
        ArrayList<String> rslt = new ArrayList<String>(Arrays.asList(locations));
        return rslt;
    }

    protected List<String> getLocations(HttpServletRequest req) {
        return this.locationsList;
    }

    private NotificationResponse readFromFile(String filename) {
        NotificationResponse rslt;
        this.logger.debug("Preparing to read from file:  {}", (Object)filename);
        URL location = this.getClass().getClassLoader().getResource(filename);
        if (location != null) {
            try {
                File f = new File(location.toURI());
                rslt = (NotificationResponse)this.mapper.readValue(f, NotificationResponse.class);
            }
            catch (Exception e) {
                String msg = "Failed to read the data file:  " + location;
                this.logger.error(msg, (Throwable)e);
                rslt = this.prepareErrorResponse(this.getName(), msg);
            }
        } else {
            String msg = "Data file not found:  " + filename;
            rslt = this.prepareErrorResponse(this.getName(), msg);
        }
        return rslt;
    }
}

