/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc;

import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.proxy.mvc.IViewSelector;

public class ThemeNameViewSelectorImpl
implements IViewSelector {
    protected static final String THEME_NAME_PROPERTY = "themeName";
    protected static final String MOBILE_THEMES_KEY = "mobileThemes";
    protected static final String[] MOBILE_THEMES_DEFAULT = new String[]{"UniversalityMobile"};
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public boolean isMobile(PortletRequest request) {
        String[] mobileThemes = request.getPreferences().getValues(MOBILE_THEMES_KEY, MOBILE_THEMES_DEFAULT);
        String themeName = request.getProperty(THEME_NAME_PROPERTY);
        if (themeName == null) {
            this.logger.debug((Object)"No theme name found, assuming desktop environment");
            return false;
        }
        for (String theme : mobileThemes) {
            if (!themeName.equals(theme)) continue;
            this.logger.debug((Object)("Theme name " + themeName + " matches configured list of mobile themes"));
            return true;
        }
        this.logger.debug((Object)("No match found for theme name " + themeName + ", assuming desktop environment"));
        return false;
    }
}

