/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayEntry;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class GatewayPortletController {
    @Autowired(required=false)
    private String viewName = "gateway";
    @Autowired(required=false)
    private String mobileViewName = "mobileGateway";
    @Autowired(required=true)
    private ApplicationContext applicationContext;
    @Autowired(required=true)
    private IViewSelector viewSelector;

    @RenderMapping
    public ModelAndView getView(RenderRequest request) {
        ModelAndView mv = new ModelAndView();
        List entries = (List)this.applicationContext.getBean("gatewayEntries", List.class);
        mv.addObject("entries", (Object)entries);
        String view = this.viewSelector.isMobile((PortletRequest)request) ? this.mobileViewName : this.viewName;
        mv.setView((Object)view);
        return mv;
    }

    @ResourceMapping
    public ModelAndView showTarget(ResourceRequest portletRequest, @RequestParam(value="index") int index) throws IOException {
        ModelAndView mv = new ModelAndView("json");
        List entries = (List)this.applicationContext.getBean("gatewayEntries", List.class);
        GatewayEntry entry = (GatewayEntry)entries.get(index);
        ArrayList<HttpContentRequestImpl> contentRequests = new ArrayList<HttpContentRequestImpl>();
        for (Map.Entry<HttpContentRequestImpl, List<String>> requestEntry : entry.getContentRequests().entrySet()) {
            HttpContentRequestImpl contentRequest = requestEntry.getKey();
            for (String interceptorKey : requestEntry.getValue()) {
                IPreInterceptor interceptor = (IPreInterceptor)this.applicationContext.getBean(interceptorKey, IPreInterceptor.class);
                interceptor.intercept(contentRequest, (PortletRequest)portletRequest);
            }
            contentRequests.add(contentRequest);
        }
        mv.addObject("contentRequests", contentRequests);
        return mv;
    }
}

