/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.proxy.mvc.portlet.proxy.ProxyPortletForm;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class EditProxyController {
    final Log log = LogFactory.getLog(this.getClass());

    @RenderMapping
    public String getEditView() {
        return "editProxyPortlet";
    }

    @ActionMapping
    public void updatePortlet(@ModelAttribute(value="form") ProxyPortletForm form, ActionRequest request, ActionResponse response) {
        try {
            PortletPreferences preferences = request.getPreferences();
            preferences.setValue("location", form.getLocation());
            preferences.setValue("contentService", form.getContentService());
            preferences.setValue("whitelistRegexes", form.getWhitelistRegexes());
            ArrayList<String> filters = new ArrayList<String>();
            if ("httpContentService".equals(form.getContentService())) {
                filters.add("urlRewritingFilter");
            }
            if (StringUtils.isNotBlank((String)form.getClippingSelector())) {
                filters.add("contentClippingFilter");
            }
            preferences.setValue("clippingSelector", form.getClippingSelector());
            preferences.setValues("filters", filters.toArray(new String[0]));
            preferences.store();
            response.setPortletMode(PortletMode.VIEW);
        }
        catch (ValidatorException e) {
            this.log.error((Object)"Unable to update web proxy portlet configuration", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to update web proxy portlet configuration", (Throwable)e);
        }
        catch (ReadOnlyException e) {
            this.log.error((Object)"Unable to update web proxy portlet configuration", (Throwable)e);
        }
        catch (PortletModeException e) {
            this.log.error((Object)"Unable to update web proxy portlet configuration", (Throwable)e);
        }
    }

    @ModelAttribute(value="form")
    public ProxyPortletForm getForm(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        ProxyPortletForm form = new ProxyPortletForm();
        form.setContentService(preferences.getValue("contentService", null));
        form.setLocation(preferences.getValue("location", null));
        form.setWhitelistRegexes(preferences.getValue("whitelistRegexes", null));
        form.setClippingSelector(preferences.getValue("clippingSelector", null));
        return form;
    }
}

