/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.springframework.web.portlet.util.PortletUtils;

public abstract class AuthenticationPreInterceptor
implements IPreInterceptor {
    public static final String AUTHENTICATION_TIMEOUT_KEY = "authenticationTimeout";
    public static final String AUTHENTICATION_TIMESTAMP_KEY = "authenticationTimestamp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intercept(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        PortletSession session = portletRequest.getPortletSession();
        Object object = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            if (!this.isAlreadyAuthenticated(portletRequest)) {
                this.prepareAuthentication(proxyRequest, portletRequest);
            }
            session.setAttribute(AUTHENTICATION_TIMEOUT_KEY, (Object)System.currentTimeMillis());
        }
    }

    protected boolean isAlreadyAuthenticated(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        PortletSession session = request.getPortletSession();
        Long timestamp = (Long)session.getAttribute(AUTHENTICATION_TIMESTAMP_KEY);
        if (timestamp == null) {
            return false;
        }
        Long timeout = Long.valueOf(preferences.getValue(AUTHENTICATION_TIMESTAMP_KEY, String.valueOf(1800000)));
        return timestamp < System.currentTimeMillis() - timeout;
    }

    protected abstract void prepareAuthentication(HttpContentRequestImpl var1, PortletRequest var2);
}

