/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.json;

import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.service.IContentRequest;
import org.jasig.portlet.proxy.service.IContentResponse;
import org.jasig.portlet.proxy.service.IContentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class JsonPortletController {
    protected static final String CONTENT_LOCATION_KEY = "location";
    protected static final String CONTENT_SERVICE_KEY = "contentService";
    protected static final String MAIN_VIEW_KEY = "mainView";
    protected static final String MOBILE_VIEW_KEY = "mobileView";
    protected final Log log = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private IViewSelector viewSelector;

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping
    public ModelAndView showContent(PortletRequest request) {
        boolean isMobile;
        ModelAndView mv = new ModelAndView();
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        IContentRequest proxyRequest = contentService.getRequest(request);
        IContentResponse proxyResponse = contentService.getContent(proxyRequest, request);
        ObjectMapper mapper = new ObjectMapper();
        ObjectReader reader = mapper.reader(Map.class);
        try {
            Map map = (Map)reader.readValue(proxyResponse.getContent());
            mv.addAllObjects(map);
        }
        catch (JsonProcessingException e) {
            this.log.error((Object)"Error parsing JSON content", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)"IOException reading JSON content", (Throwable)e);
        }
        finally {
            proxyResponse.close();
        }
        String mainView = preferences.getValue(MAIN_VIEW_KEY, null);
        String mobileView = preferences.getValue(MOBILE_VIEW_KEY, null);
        String viewName = mobileView != null ? ((isMobile = this.viewSelector.isMobile(request)) ? mobileView : mainView) : mainView;
        mv.setViewName(viewName);
        return mv;
    }
}

