/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.proxy.service.IContentRequest;
import org.jasig.portlet.proxy.service.IContentResponse;
import org.jasig.portlet.proxy.service.IContentService;
import org.jasig.portlet.proxy.service.proxy.document.IDocumentFilter;
import org.jasig.portlet.proxy.service.web.HttpContentResponseImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ProxyPortletController {
    protected static final String CONTENT_SERVICE_KEY = "contentService";
    protected static final String FILTER_LIST_KEY = "filters";
    protected final Log log = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private List<Pattern> knownHtmlContentTypes = new ArrayList();

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Required
    @Resource(name="knownHtmlContentTypes")
    public void setKnownHtmlContentTypes(List<String> contentTypes) {
        this.knownHtmlContentTypes.clear();
        for (String contentType : contentTypes) {
            this.knownHtmlContentTypes.add(Pattern.compile(contentType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderMapping
    public void showContent(RenderRequest request, RenderResponse response) {
        String[] filterKeys;
        IContentResponse proxyResponse;
        IContentRequest proxyRequest;
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        try {
            proxyRequest = contentService.getRequest((PortletRequest)request);
        }
        catch (RuntimeException e) {
            this.log.error((Object)"URL was not in the proxy list");
            return;
        }
        try {
            proxyResponse = contentService.getContent(proxyRequest, (PortletRequest)request);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to proxy content", (Throwable)e);
            return;
        }
        ArrayList<IDocumentFilter> filters = new ArrayList<IDocumentFilter>();
        for (String filterKey : filterKeys = preferences.getValues(FILTER_LIST_KEY, new String[0])) {
            IDocumentFilter filter = (IDocumentFilter)this.applicationContext.getBean(filterKey, IDocumentFilter.class);
            filters.add(filter);
        }
        try {
            Document document = Jsoup.parse((InputStream)proxyResponse.getContent(), (String)"UTF-8", (String)proxyResponse.getProxiedLocation());
            for (IDocumentFilter filter : filters) {
                filter.filter(document, proxyResponse, request, response);
            }
            try {
                OutputStream out = response.getPortletOutputStream();
                IOUtils.write((String)document.html(), (OutputStream)out);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                this.log.error((Object)"Exception writing proxied content", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Error parsing HTML content", (Throwable)e);
        }
        finally {
            proxyResponse.close();
        }
    }

    @ActionMapping
    public void proxyTarget(@RequestParam(value="proxy.url") String url, ActionRequest request, ActionResponse response) throws IOException {
        IContentRequest proxyRequest;
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        try {
            proxyRequest = contentService.getRequest((PortletRequest)request);
        }
        catch (RuntimeException e) {
            this.log.error((Object)("URL " + url + " was not in the proxy list"));
            return;
        }
        IContentResponse proxyResponse = contentService.getContent(proxyRequest, (PortletRequest)request);
        proxyResponse.close();
        if (proxyResponse instanceof HttpContentResponseImpl) {
            HttpContentResponseImpl httpContentResponse = (HttpContentResponseImpl)proxyResponse;
            String responseContentType = (String)httpContentResponse.getHeaders().get("Content-Type");
            for (Pattern contentType : this.knownHtmlContentTypes) {
                if (responseContentType == null || !contentType.matcher(responseContentType).matches()) continue;
                Map params = request.getParameterMap();
                response.setRenderParameters(params);
                return;
            }
        }
        PortletSession session = request.getPortletSession();
        ConcurrentMap rewrittenUrls = (ConcurrentMap)session.getAttribute("rewrittenUrls");
        response.sendRedirect((String)rewrittenUrls.get(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResourceMapping
    public void proxyResourceTarget(@RequestParam(value="proxy.url") String url, ResourceRequest request, ResourceResponse response) {
        IContentRequest proxyRequest;
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        try {
            proxyRequest = contentService.getRequest((PortletRequest)request);
        }
        catch (RuntimeException e) {
            this.log.error((Object)("URL " + url + " was not in the proxy list"));
            response.setProperty("portlet.http-status-code", String.valueOf(401));
            return;
        }
        IContentResponse proxyResponse = contentService.getContent(proxyRequest, (PortletRequest)request);
        try {
            if (proxyResponse instanceof HttpContentResponseImpl) {
                HttpContentResponseImpl httpProxyResponse = (HttpContentResponseImpl)proxyResponse;
                for (Map.Entry header : httpProxyResponse.getHeaders().entrySet()) {
                    response.setProperty((String)header.getKey(), (String)header.getValue());
                }
            }
            OutputStream out = response.getPortletOutputStream();
            IOUtils.copyLarge((InputStream)proxyResponse.getContent(), (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            response.setProperty("portlet.http-status-code", String.valueOf(401));
            this.log.error((Object)"Exception writing proxied content", (Throwable)e);
        }
        finally {
            proxyResponse.close();
        }
    }
}

