/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.xslt;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.service.IContentRequest;
import org.jasig.portlet.proxy.service.IContentResponse;
import org.jasig.portlet.proxy.service.IContentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.servlet.view.xslt.XsltView;

@Controller
@RequestMapping(value={"VIEW"})
public class XsltPortletController {
    protected static final String CONTENT_LOCATION_KEY = "location";
    protected static final String CONTENT_SERVICE_KEY = "contentService";
    protected static final String MAIN_XSLT_KEY = "mainXslt";
    protected static final String MOBILE_XSLT_KEY = "mobileXslt";
    protected final Log log = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private IViewSelector viewSelector;

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping
    public ModelAndView showContent(PortletRequest request) {
        boolean isMobile;
        ModelAndView mv = new ModelAndView();
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        IContentRequest proxyRequest = contentService.getRequest(request);
        IContentResponse proxyResponse = contentService.getContent(proxyRequest, request);
        try {
            mv.addObject("xml", (Object)proxyResponse.getContent());
        }
        finally {
            proxyResponse.close();
        }
        String mainXslt = preferences.getValue(MAIN_XSLT_KEY, null);
        String mobileXslt = preferences.getValue(MOBILE_XSLT_KEY, null);
        String xslt = mobileXslt != null ? ((isMobile = this.viewSelector.isMobile(request)) ? mobileXslt : mainXslt) : mainXslt;
        XsltView view = new XsltView();
        view.setUrl(xslt);
        view.setSourceKey("xml");
        view.setApplicationContext(this.applicationContext);
        mv.setView((Object)view);
        return mv;
    }
}

