/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.proxy.service.GenericContentRequestImpl;
import org.jasig.portlet.proxy.service.web.HttpContentServiceImpl;

public class HttpContentRequestImpl
extends GenericContentRequestImpl {
    private Map<String, String[]> parameters = new HashMap();
    private Map<String, String> headers = new HashMap();
    private String method;
    private boolean isForm;

    public HttpContentRequestImpl() {
    }

    public HttpContentRequestImpl(PortletRequest request) {
        this();
        String urlParam = request.getParameter(HttpContentServiceImpl.URL_PARAM);
        if (urlParam != null) {
            PortletSession session = request.getPortletSession();
            ConcurrentMap rewrittenUrls = (ConcurrentMap)session.getAttribute("rewrittenUrls");
            if (!rewrittenUrls.containsKey(urlParam)) {
                throw new RuntimeException("Illegal URL " + urlParam);
            }
            this.setProxiedLocation(urlParam);
        } else {
            PortletPreferences preferences = request.getPreferences();
            this.setProxiedLocation(preferences.getValue("location", null));
        }
        Map params = request.getParameterMap();
        for (Map.Entry param : params.entrySet()) {
            if (((String)param.getKey()).startsWith("proxy.")) continue;
            this.parameters.put(param.getKey(), param.getValue());
        }
        this.isForm = Boolean.valueOf(request.getParameter(HttpContentServiceImpl.IS_FORM_PARAM));
        this.method = request.getParameter(HttpContentServiceImpl.FORM_METHOD_PARAM);
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isForm() {
        return this.isForm;
    }

    public void setForm(boolean isForm) {
        this.isForm = isForm;
    }
}

