/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.springframework.stereotype.Service;

@Service(value="userInfoUrlParameterizingPreInterceptor")
public class UserInfoUrlParameterizingPreInterceptor
implements IPreInterceptor {
    protected final Log log = LogFactory.getLog(this.getClass());

    public void intercept(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        try {
            String url = proxyRequest.getProxiedLocation();
            Map userInfo = (Map)portletRequest.getAttribute("javax.portlet.userinfo");
            for (String key : userInfo.keySet()) {
                String token = "{".concat(key).concat("}");
                if (url.contains(token)) {
                    url = url.replaceAll("\\{".concat(key).concat("\\}"), URLEncoder.encode((String)userInfo.get(key), "UTF-8"));
                }
                for (Map.Entry param : proxyRequest.getParameters().entrySet()) {
                    int length = ((String[])param.getValue()).length;
                    for (int i = 0; i < length; ++i) {
                        String value = ((String[])param.getValue())[i];
                        if (!value.contains(token)) continue;
                        ((String[])param.getValue())[i] = value.replaceAll("\\{".concat(key).concat("\\}"), (String)userInfo.get(key));
                    }
                }
            }
            proxyRequest.setProxiedLocation(url);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"Exception while encoding URL parameters", (Throwable)e);
        }
    }
}

