/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc;

import javax.portlet.PortletRequest;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeNameViewSelectorImpl
implements IViewSelector {
    protected static final String THEME_NAME_PROPERTY = "themeName";
    protected static final String MOBILE_THEMES_KEY = "mobileThemes";
    protected static final String[] MOBILE_THEMES_DEFAULT = new String[]{"UniversalityMobile"};
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean isMobile(PortletRequest request) {
        String[] mobileThemes = request.getPreferences().getValues(MOBILE_THEMES_KEY, MOBILE_THEMES_DEFAULT);
        String themeName = request.getProperty(THEME_NAME_PROPERTY);
        if (themeName == null) {
            this.logger.debug("No theme name found, assuming desktop environment");
            return false;
        }
        for (String theme : mobileThemes) {
            if (!themeName.equals(theme)) continue;
            this.logger.debug("Theme name {} matches configured list of mobile themes", (Object)themeName);
            return true;
        }
        this.logger.debug("No match found for theme name {}, assuming desktop environment", (Object)themeName);
        return false;
    }
}

