/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayEntry;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.IAuthenticationFormModifier;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class GatewayPortletController {
    private static final String HTTPS = "HTTPS";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private String viewName = "gateway";
    @Autowired(required=false)
    private String mobileViewName = "mobileGateway";
    @Autowired(required=true)
    private ApplicationContext applicationContext;
    @Autowired(required=true)
    private IViewSelector viewSelector;

    @RenderMapping
    public ModelAndView getView(RenderRequest request) {
        ModelAndView mv = new ModelAndView();
        List entries = (List)this.applicationContext.getBean("gatewayEntries", List.class);
        HashMap<String, Boolean> validations = new HashMap<String, Boolean>();
        for (GatewayEntry entry : entries) {
            for (Map.Entry<HttpContentRequestImpl, List<String>> requestEntry : entry.getContentRequests().entrySet()) {
                HttpContentRequestImpl contentRequest = requestEntry.getKey();
                for (String interceptorKey : requestEntry.getValue()) {
                    IPreInterceptor interceptor = (IPreInterceptor)this.applicationContext.getBean(interceptorKey, IPreInterceptor.class);
                    boolean isValid = interceptor.validate(contentRequest, (PortletRequest)request);
                    validations.put(entry.getName(), isValid);
                }
            }
        }
        mv.addObject("entries", (Object)entries);
        mv.addObject("validations", validations);
        String openInNewPage = request.getPreferences().getValue("openInNewPage", "true");
        mv.addObject("openInNewPage", (Object)openInNewPage);
        String view = this.viewSelector.isMobile((PortletRequest)request) ? this.mobileViewName : this.viewName;
        mv.setView((Object)view);
        return mv;
    }

    @ResourceMapping
    public String showTarget(ResourceRequest portletRequest, ResourceResponse portletResponse, Model model, @RequestParam(value="index") int index) throws IOException {
        this.prepareGatewayResponse(portletRequest, portletResponse, index, model);
        return "json";
    }

    @ResourceMapping(value="showTargetInNewWindow")
    public String showTargetInNewWindow(ResourceRequest portletRequest, ResourceResponse portletResponse, Model model, @RequestParam(value="index") int index) throws IOException {
        model.addAttribute("index", (Object)index);
        return "gatewayNewPage";
    }

    private void prepareGatewayResponse(ResourceRequest portletRequest, ResourceResponse portletResponse, int index, Model model) throws IOException {
        List entries = (List)this.applicationContext.getBean("gatewayEntries", List.class);
        GatewayEntry entry = (GatewayEntry)entries.get(index);
        ArrayList<HttpContentRequestImpl> contentRequests = new ArrayList<HttpContentRequestImpl>();
        for (Map.Entry<HttpContentRequestImpl, List<String>> requestEntry : entry.getContentRequests().entrySet()) {
            HttpContentRequestImpl contentRequest = requestEntry.getKey().duplicate();
            for (String interceptorKey : requestEntry.getValue()) {
                IPreInterceptor interceptor = (IPreInterceptor)this.applicationContext.getBean(interceptorKey, IPreInterceptor.class);
                interceptor.intercept(contentRequest, (PortletRequest)portletRequest);
            }
            contentRequests.add(contentRequest);
        }
        for (IAuthenticationFormModifier authenticationFormModifier : entry.getAuthenticationFormModifier()) {
            String fieldName = authenticationFormModifier.getFieldName();
            String result = authenticationFormModifier.getResult(portletRequest.getPreferences());
            for (HttpContentRequestImpl contentRequest : contentRequests) {
                contentRequest.addParameter(fieldName, result);
            }
        }
        for (HttpContentRequestImpl contentRequest : contentRequests) {
            if (contentRequest.getParameters().get("proxiedLocation") != null) {
                contentRequest.setProxiedLocation(contentRequest.getParameters().get("proxiedLocation").getValue());
            }
            if (!entry.isRequireSecure() || !StringUtils.isNotBlank((String)contentRequest.getProxiedLocation()) || contentRequest.getProxiedLocation().length() < HTTPS.length() || HTTPS.equalsIgnoreCase(contentRequest.getProxiedLocation().substring(0, HTTPS.length()))) continue;
            this.logger.error("Proxied location '" + contentRequest.getProxiedLocation() + "' for gateway entry " + entry.getName() + " is not secure - discarding entry!!!");
            contentRequest.setParameters(new HashMap<String, IFormField>());
            contentRequest.setProxiedLocation("/HTTPSUrlRequiredButNotSpecified");
        }
        model.addAttribute("contentRequests", contentRequests);
        portletResponse.setProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        portletResponse.setProperty("Pragma", "no-cache");
        portletResponse.setProperty("Expires", "0");
    }
}

