/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.gateway;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayEntry;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayPreference;
import org.jasig.portlet.proxy.security.IStringEncryptionService;
import org.jasig.portlet.proxy.security.StringEncryptionException;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"EDIT"})
public class GatewayPortletEditController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String preferencesRegex;
    private IStringEncryptionService stringEncryptionService;
    @Autowired(required=false)
    private String viewName = "gatewayEdit";
    @Autowired(required=false)
    private String mobileViewName = "mobileGatewayEdit";
    @Autowired(required=true)
    private ApplicationContext applicationContext;
    @Autowired(required=true)
    private IViewSelector viewSelector;

    @Value(value="${login.preferences.regex}")
    public void setPreferencesRegex(String preferencesRegex) {
        this.preferencesRegex = preferencesRegex;
    }

    @Autowired(required=false)
    public void setStringEncryptionService(IStringEncryptionService stringEncryptionService) {
        this.stringEncryptionService = stringEncryptionService;
    }

    @RequestMapping
    public ModelAndView getView(RenderRequest request) {
        PortletPreferences prefs = request.getPreferences();
        ModelAndView mv = new ModelAndView();
        List entries = (List)this.applicationContext.getBean("gatewayEntries", List.class);
        TreeMap<String, GatewayPreference> gatewayPreferences = new TreeMap<String, GatewayPreference>();
        for (GatewayEntry entry : entries) {
            for (Map.Entry<HttpContentRequestImpl, List<String>> requestEntry : entry.getContentRequests().entrySet()) {
                HttpContentRequestImpl contentRequest = requestEntry.getKey();
                Map<String, IFormField> parameters = contentRequest.getParameters();
                for (String logicalFieldName : parameters.keySet()) {
                    IFormField parameter = parameters.get(logicalFieldName);
                    for (String parameterValue : parameter.getValues()) {
                        String preferenceName;
                        if (!parameterValue.matches(this.preferencesRegex) || gatewayPreferences.get(preferenceName = parameterValue) != null) continue;
                        String preferredValue = prefs.getValue(preferenceName, "");
                        if (parameter.getSecured() && StringUtils.isNotBlank((String)preferredValue) && this.stringEncryptionService != null) {
                            preferredValue = this.stringEncryptionService.decrypt(preferredValue);
                        }
                        gatewayPreferences.put(preferenceName, new GatewayPreference(entry.getName(), logicalFieldName, preferenceName, preferredValue, parameter.getSecured()));
                    }
                }
            }
        }
        mv.addObject("gatewayPreferences", gatewayPreferences.descendingMap());
        String view = this.viewSelector.isMobile((PortletRequest)request) ? this.mobileViewName : this.viewName;
        mv.setView((Object)view);
        return mv;
    }

    @RequestMapping(params={"action=savePreferences"})
    public void savePreferences(ActionRequest request, ActionResponse response) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.matches(this.preferencesRegex)) continue;
            String parameterValue = request.getParameter(parameterName);
            IFormField parameter = this.getPortletPreferenceFormField(parameterName);
            if (parameter != null && parameter.getSecured() && StringUtils.isNotBlank((String)parameterValue)) {
                if (this.stringEncryptionService == null) {
                    throw new StringEncryptionException("String encryption service must be configured!");
                }
                parameterValue = this.stringEncryptionService.encrypt(parameterValue);
            }
            prefs.setValue(parameterName, parameterValue);
        }
        prefs.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    private IFormField getPortletPreferenceFormField(String fieldName) {
        IFormField formField = null;
        List entries = (List)this.applicationContext.getBean("gatewayEntries", List.class);
        for (GatewayEntry entry : entries) {
            block1: for (Map.Entry<HttpContentRequestImpl, List<String>> requestEntry : entry.getContentRequests().entrySet()) {
                HttpContentRequestImpl contentRequest = requestEntry.getKey();
                Map<String, IFormField> parameters = contentRequest.getParameters();
                for (String parameterNames : parameters.keySet()) {
                    IFormField parameter = parameters.get(parameterNames);
                    if (!parameter.getValue().equals(fieldName)) continue;
                    formField = parameter;
                    continue block1;
                }
            }
            if (formField == null) continue;
            break;
        }
        return formField;
    }
}

