/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.jasig.portlet.proxy.service.web.IHttpClientService;
import org.jasig.portlet.proxy.service.web.RedirectTrackingResponseInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.portlet.util.PortletUtils;

@Service
public class MultiRequestHttpClientServiceImpl
implements IHttpClientService {
    protected static final String CLIENT_SESSION_KEY = "httpClient";
    protected static final String SHARED_SESSION_KEY = "sharedSessionKey";
    private PoolingClientConnectionManager connectionManager;

    @Autowired(required=true)
    public void setPoolingClientConnectionManager(PoolingClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractHttpClient getHttpClient(PortletRequest request) {
        AbstractHttpClient client;
        PortletSession session = request.getPortletSession();
        PortletPreferences preferences = request.getPreferences();
        String sharedSessionKey = preferences.getValue(SHARED_SESSION_KEY, null);
        int scope = sharedSessionKey != null ? 1 : 2;
        String clientSessionKey = sharedSessionKey != null ? sharedSessionKey : CLIENT_SESSION_KEY;
        Object object = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            client = (AbstractHttpClient)session.getAttribute(clientSessionKey, scope);
            if (client == null) {
                client = this.createHttpClient(request);
                session.setAttribute(clientSessionKey, (Object)client, scope);
            }
        }
        return client;
    }

    protected AbstractHttpClient createHttpClient(PortletRequest request) {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);
        client.addResponseInterceptor((HttpResponseInterceptor)new RedirectTrackingResponseInterceptor());
        return client;
    }
}

