/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.mvc.portlet.proxy.ProxyPortletForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class EditProxyController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @RenderMapping
    public String getEditView() {
        return "editProxyPortlet";
    }

    @ActionMapping
    public void updatePortlet(@ModelAttribute(value="form") ProxyPortletForm form, ActionRequest request, ActionResponse response) {
        try {
            PortletPreferences preferences = request.getPreferences();
            preferences.setValue("location", form.getLocation());
            preferences.setValue("contentService", form.getContentService());
            preferences.setValue("whitelistRegexes", form.getWhitelistRegexes());
            ArrayList<String> filters = new ArrayList<String>();
            if (StringUtils.isNotBlank((String)form.getClippingSelector())) {
                filters.add("contentClippingFilter");
            }
            preferences.setValue("clippingSelector", form.getClippingSelector());
            if (StringUtils.isNotBlank((String)form.getHeader()) || StringUtils.isNotBlank((String)form.getFooter())) {
                preferences.setValue("headerHtml", form.getHeader());
                preferences.setValue("footerHtml", form.getFooter());
                filters.add("headerFooterFilter");
            }
            if ("httpContentService".equals(form.getContentService())) {
                filters.add("urlRewritingFilter");
            }
            preferences.setValues("filters", filters.toArray(new String[0]));
            ArrayList<String> preInterceptors = new ArrayList<String>();
            preInterceptors.add("userInfoUrlParameterizingPreInterceptor");
            ProxyPortletForm.ProxyAuthType authType = form.getAuthType();
            if (authType.equals((Object)ProxyPortletForm.ProxyAuthType.BASIC)) {
                preInterceptors.add("userInfoBasicAuthenticationPreInterceptor");
            } else if (authType.equals((Object)ProxyPortletForm.ProxyAuthType.CAS)) {
                preInterceptors.add("proxyCASAuthenticationPreInterceptor");
            }
            preferences.setValue("authType", form.getAuthType().toString());
            preferences.setValues("preInterceptors", preInterceptors.toArray(new String[0]));
            preferences.store();
            response.setPortletMode(PortletMode.VIEW);
        }
        catch (Exception e) {
            this.log.error("Unable to update web proxy portlet configuration", (Throwable)e);
        }
    }

    @ModelAttribute(value="form")
    public ProxyPortletForm getForm(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        ProxyPortletForm form = new ProxyPortletForm();
        form.setContentService(preferences.getValue("contentService", null));
        form.setLocation(preferences.getValue("location", null));
        form.setWhitelistRegexes(preferences.getValue("whitelistRegexes", null));
        form.setClippingSelector(preferences.getValue("clippingSelector", null));
        String authTypeForm = preferences.getValue("authType", null);
        ProxyPortletForm.ProxyAuthType authType = ProxyPortletForm.ProxyAuthType.NONE;
        if (!StringUtils.isBlank((String)authTypeForm)) {
            authType = ProxyPortletForm.ProxyAuthType.valueOf((String)authTypeForm);
        }
        form.setAuthType(authType);
        return form;
    }
}

