/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.jasig.portlet.proxy.service.GenericContentRequestImpl;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.FormFieldImpl;
import org.jasig.portlet.proxy.service.web.HttpContentServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContentRequestImpl
extends GenericContentRequestImpl {
    private static final Logger log = LoggerFactory.getLogger(HttpContentRequestImpl.class);
    private Map<String, IFormField> parameters = new HashMap();
    private Map<String, String> headers = new HashMap();
    private String method;
    private boolean isForm;

    public HttpContentRequestImpl() {
    }

    public HttpContentRequestImpl(PortletRequest request) {
        this();
        String urlParam = request.getParameter(HttpContentServiceImpl.URL_PARAM);
        if (urlParam != null) {
            PortletSession session = request.getPortletSession();
            ConcurrentMap rewrittenUrls = (ConcurrentMap)session.getAttribute("rewrittenUrls");
            if (!rewrittenUrls.containsKey(urlParam)) {
                throw new RuntimeException("Illegal URL " + urlParam);
            }
            this.setProxiedLocation(urlParam);
        } else {
            PortletPreferences preferences = request.getPreferences();
            this.setProxiedLocation(preferences.getValue("location", null));
        }
        Map params = request.getParameterMap();
        for (Map.Entry param : params.entrySet()) {
            if (((String)param.getKey()).startsWith("proxy.")) continue;
            FormFieldImpl formField = new FormFieldImpl((String)param.getKey(), (String[])param.getValue());
            this.parameters.put(param.getKey(), formField);
        }
        this.isForm = Boolean.valueOf(request.getParameter(HttpContentServiceImpl.IS_FORM_PARAM));
        this.method = request.getParameter(HttpContentServiceImpl.FORM_METHOD_PARAM);
    }

    public void addParameter(String fieldName, String value) {
        FormFieldImpl field = new FormFieldImpl();
        field.setName(fieldName);
        field.setValue(value);
        this.parameters.put(fieldName, field);
    }

    public Map<String, IFormField> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, IFormField> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isForm() {
        return this.isForm;
    }

    public void setForm(boolean isForm) {
        this.isForm = isForm;
    }

    public HttpContentRequestImpl duplicate() {
        HttpContentRequestImpl copy = new HttpContentRequestImpl();
        copy.setMethod(this.getMethod());
        copy.setForm(this.isForm());
        copy.setProxiedLocation(this.getProxiedLocation());
        LinkedHashMap copyHeaders = new LinkedHashMap();
        copyHeaders.putAll(this.headers);
        copy.setHeaders(copyHeaders);
        LinkedHashMap<String, IFormField> copyParameters = new LinkedHashMap<String, IFormField>();
        for (Map.Entry requestEntry : this.getParameters().entrySet()) {
            String key = (String)requestEntry.getKey();
            IFormField values = (IFormField)requestEntry.getValue();
            copyParameters.put(key, values.duplicate());
        }
        copy.setParameters(copyParameters);
        return copy;
    }
}

