/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.jasig.portlet.proxy.service.web.IHttpClientService;
import org.jasig.portlet.proxy.service.web.RedirectTrackingResponseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.portlet.util.PortletUtils;

@Service
public class MultiRequestHttpClientServiceImpl
implements IHttpClientService {
    private static final Logger LOG = LoggerFactory.getLogger(MultiRequestHttpClientServiceImpl.class);
    private static final String HTTP_CLIENT_CONNECTION_TIMEOUT = "httpClientConnectionTimeout";
    private static final String HTTP_CLIENT_SOCKET_TIMEOUT = "httpClientSocketTimeout";
    private static final int DEFAULT_HTTP_CLIENT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 10000;
    protected static final String CLIENT_SESSION_KEY = "httpClient";
    protected static final String SHARED_SESSION_KEY = "sharedSessionKey";
    private PoolingClientConnectionManager connectionManager;

    @Autowired(required=true)
    public void setPoolingClientConnectionManager(PoolingClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractHttpClient getHttpClient(PortletRequest request) {
        AbstractHttpClient client;
        PortletSession session = request.getPortletSession();
        PortletPreferences preferences = request.getPreferences();
        String sharedSessionKey = preferences.getValue(SHARED_SESSION_KEY, null);
        int scope = sharedSessionKey != null ? 1 : 2;
        String clientSessionKey = sharedSessionKey != null ? sharedSessionKey : CLIENT_SESSION_KEY;
        Object object = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            client = (AbstractHttpClient)session.getAttribute(clientSessionKey, scope);
            if (client == null) {
                client = this.createHttpClient(request);
                session.setAttribute(clientSessionKey, (Object)client, scope);
            }
        }
        client = this.setHttpClientTimeouts(request, client);
        return client;
    }

    protected AbstractHttpClient createHttpClient(PortletRequest request) {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);
        client.addResponseInterceptor((HttpResponseInterceptor)new RedirectTrackingResponseInterceptor());
        return client;
    }

    private AbstractHttpClient setHttpClientTimeouts(PortletRequest request, AbstractHttpClient client) {
        PortletPreferences prefs = request.getPreferences();
        HttpParams params = client.getParams();
        if (params == null) {
            params = new BasicHttpParams();
            client.setParams(params);
        }
        int httpClientConnectionTimeout = Integer.parseInt(prefs.getValue(HTTP_CLIENT_CONNECTION_TIMEOUT, String.valueOf(10000)));
        int httpClientSocketTimeout = Integer.parseInt(prefs.getValue(HTTP_CLIENT_SOCKET_TIMEOUT, String.valueOf(10000)));
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)httpClientConnectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)httpClientSocketTimeout);
        return client;
    }
}

