/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.proxy.service.IContentResponse;
import org.jasig.portlet.proxy.service.IContentService;
import org.jasig.portlet.proxy.service.proxy.document.IDocumentFilter;
import org.jasig.portlet.proxy.service.web.HttpContentResponseImpl;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ProxyPortletController {
    protected static final String CONTENT_SERVICE_KEY = "contentService";
    protected static final String FILTER_LIST_KEY = "filters";
    public static final String PREF_CHARACTER_ENCODING = "sourcePageCharacterEncoding";
    public static final String CHARACTER_ENCODING_DEFAULT = "UTF-8";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;
    private List<Pattern> knownHtmlContentTypes = new ArrayList<Pattern>();

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Required
    @Resource(name="knownHtmlContentTypes")
    public void setKnownHtmlContentTypes(List<String> contentTypes) {
        this.knownHtmlContentTypes.clear();
        for (String contentType : contentTypes) {
            this.knownHtmlContentTypes.add(Pattern.compile(contentType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RenderMapping
    public void showContent(RenderRequest request, RenderResponse response) {
        String[] filterKeys;
        Object proxyResponse;
        Object proxyRequest;
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        try {
            proxyRequest = contentService.getRequest((PortletRequest)request);
        }
        catch (RuntimeException e) {
            this.log.error("URL was not in the proxy list");
            return;
        }
        try {
            proxyResponse = contentService.getContent(proxyRequest, (PortletRequest)request);
        }
        catch (Exception e) {
            this.log.error("Failed to proxy content", (Throwable)e);
            return;
        }
        ArrayList<IDocumentFilter> filters = new ArrayList<IDocumentFilter>();
        for (String filterKey : filterKeys = preferences.getValues(FILTER_LIST_KEY, new String[0])) {
            IDocumentFilter filter = (IDocumentFilter)this.applicationContext.getBean(filterKey, IDocumentFilter.class);
            filters.add(filter);
        }
        try {
            String sourceEncodingFormat = preferences.getValue(PREF_CHARACTER_ENCODING, CHARACTER_ENCODING_DEFAULT);
            Document document = Jsoup.parse((InputStream)proxyResponse.getContent(), (String)sourceEncodingFormat, (String)proxyResponse.getProxiedLocation());
            for (IDocumentFilter filter : filters) {
                filter.filter(document, (IContentResponse)proxyResponse, request, response);
            }
            OutputStream out = null;
            try {
                out = response.getPortletOutputStream();
                IOUtils.write((String)document.html(), (OutputStream)out);
                out.flush();
            }
            catch (IOException e) {
                this.log.error("Exception writing proxied content", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            this.log.error("Error parsing HTML content", (Throwable)e);
        }
        finally {
            if (proxyResponse != null) {
                proxyResponse.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ActionMapping
    public void proxyTarget(@RequestParam(value="proxy.url") String url, ActionRequest request, ActionResponse response) throws IOException {
        PortletPreferences preferences = request.getPreferences();
        try (IContentResponse proxyResponse = null;){
            Object proxyRequest;
            String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
            IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
            try {
                proxyRequest = contentService.getRequest((PortletRequest)request);
            }
            catch (RuntimeException e) {
                this.log.error("URL {} was not in the proxy list", (Object)url);
                if (proxyResponse != null) {
                    proxyResponse.close();
                }
                return;
            }
            proxyResponse = contentService.getContent(proxyRequest, (PortletRequest)request);
            if (proxyResponse instanceof HttpContentResponseImpl) {
                HttpContentResponseImpl httpContentResponse = (HttpContentResponseImpl)proxyResponse;
                String responseContentType = httpContentResponse.getHeaders().get("Content-Type");
                for (Pattern contentType : this.knownHtmlContentTypes) {
                    if (responseContentType == null || !contentType.matcher(responseContentType).matches()) continue;
                    Map params = request.getParameterMap();
                    response.setRenderParameters(params);
                    return;
                }
            }
            PortletSession session = request.getPortletSession();
            ConcurrentMap rewrittenUrls = (ConcurrentMap)session.getAttribute("rewrittenUrls");
            response.sendRedirect((String)rewrittenUrls.get(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResourceMapping
    public void proxyResourceTarget(@RequestParam(value="proxy.url") String url, ResourceRequest request, ResourceResponse response) {
        Object proxyRequest;
        PortletPreferences preferences = request.getPreferences();
        String contentServiceKey = preferences.getValue(CONTENT_SERVICE_KEY, null);
        IContentService contentService = (IContentService)this.applicationContext.getBean(contentServiceKey, IContentService.class);
        try {
            proxyRequest = contentService.getRequest((PortletRequest)request);
        }
        catch (RuntimeException e) {
            this.log.error("URL {} was not in the proxy list", (Object)url);
            response.setProperty("portlet.http-status-code", String.valueOf(401));
            return;
        }
        Object proxyResponse = contentService.getContent(proxyRequest, (PortletRequest)request);
        OutputStream out = null;
        try {
            if (proxyResponse instanceof HttpContentResponseImpl) {
                HttpContentResponseImpl httpProxyResponse = (HttpContentResponseImpl)proxyResponse;
                for (Map.Entry<String, String> header : httpProxyResponse.getHeaders().entrySet()) {
                    response.setProperty(header.getKey(), header.getValue());
                }
            }
            out = response.getPortletOutputStream();
            IOUtils.copyLarge((InputStream)proxyResponse.getContent(), (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            response.setProperty("portlet.http-status-code", String.valueOf(401));
            this.log.error("Exception writing proxied content", (Throwable)e);
        }
        finally {
            if (proxyResponse != null) {
                proxyResponse.close();
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

