/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import org.jasig.portal.search.SearchConstants;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResults;
import org.jasig.portlet.proxy.search.ISearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class SearchProxyController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISearchService searchService;

    @Required
    @Resource(name="contentSearchProvider")
    public void setSearchService(ISearchService searchService) {
        this.searchService = searchService;
    }

    @EventMapping(value="{https://source.jasig.org/schemas/uportal/search}SearchRequest")
    public void searchRequest(EventRequest request, EventResponse response) {
        this.log.debug("EVENT HANDLER -- START");
        Event event = request.getEvent();
        SearchRequest searchQuery = (SearchRequest)event.getValue();
        SearchResults searchResults = this.searchService.search(searchQuery, request);
        response.setEvent(SearchConstants.SEARCH_RESULTS_QNAME, (Serializable)searchResults);
        this.log.debug("EVENT HANDLER -- END");
    }
}

