/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.IOUtils;
import org.jasig.portlet.proxy.service.GenericContentResponseImpl;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.HttpContentServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;

@Service(value="httpContentService")
public class CachingHttpContentServiceImpl
extends HttpContentServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(CachingHttpContentServiceImpl.class);
    private Cache cache;

    @Required
    @Resource(name="urlCache")
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public GenericContentResponseImpl getContent(HttpContentRequestImpl proxyRequest, PortletRequest request) {
        GenericContentResponseImpl response = null;
        super.beforeGetContent(proxyRequest, request);
        String cacheKey = proxyRequest.getProxiedLocation();
        Element cachedElement = this.cache.get((Serializable)((Object)cacheKey));
        if (cachedElement == null) {
            LOG.debug("Cache miss for cacheKey: {}", (Object)cacheKey);
            response = super.getContent(proxyRequest, request, false);
            try {
                response.setContent((InputStream)new ByteArrayInputStream(IOUtils.toByteArray((InputStream)response.getContent())));
                cachedElement = new Element((Object)cacheKey, (Object)response);
                this.cache.put(cachedElement);
            }
            catch (IOException ioexception) {
                LOG.error("Exception retrieving remote content", (Throwable)ioexception);
            }
        } else {
            LOG.debug("Cache hit for cacheKey: {}", (Object)cacheKey);
            response = (GenericContentResponseImpl)cachedElement.getValue();
            try {
                response.getContent().reset();
            }
            catch (IOException ioException) {
                LOG.error("Error retrieving cached page. Resending request...");
                this.cache.remove((Serializable)((Object)cacheKey));
                return this.getContent(proxyRequest, request);
            }
        }
        return response;
    }
}

