/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.proxy;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.mvc.portlet.proxy.ProxyPortletForm;
import org.jasig.portlet.proxy.search.ISearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"CONFIG"})
public class EditProxyController {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> pageCharacterEncodings;
    private ISearchService searchService;

    @Resource(name="pageCharacterEncodings")
    public void setPageCharacterEncodings(Map<String, String> pageCharacterEncodings) {
        this.pageCharacterEncodings = pageCharacterEncodings;
    }

    @ModelAttribute(value="pageCharacterEncodings")
    public Map<String, String> getPageCharacterEncodings() {
        return this.pageCharacterEncodings;
    }

    @Required
    @Resource(name="contentSearchProvider")
    public void setSearchService(ISearchService searchService) {
        this.searchService = searchService;
    }

    @RenderMapping
    public String getEditView(PortletRequest request, Model model) {
        model.addAttribute("form", (Object)this.getForm(request));
        model.addAttribute("strategyNames", (Object)this.searchService.getStrategyNames());
        return "editProxyPortlet";
    }

    @ActionMapping
    public void updatePortlet(@ModelAttribute(value="form") ProxyPortletForm form, ActionRequest request, ActionResponse response, @RequestParam(value="Save", required=false) String save) throws PortletModeException {
        if (StringUtils.isNotBlank((String)save)) {
            try {
                PortletPreferences preferences = request.getPreferences();
                preferences.setValue("location", form.getLocation());
                preferences.setValue("location.MAXIMIZED", form.getMaxLocation());
                preferences.setValue("contentService", form.getContentService());
                preferences.setValue("whitelistRegexes", form.getWhitelistRegexes());
                preferences.setValue("sourcePageCharacterEncoding", form.getPageCharacterEncodingFormat());
                ArrayList<String> filters = new ArrayList<String>();
                preferences.setValue("clippingSelector", form.getClippingSelector());
                if (StringUtils.isNotBlank((String)form.getClippingSelector())) {
                    filters.add("contentClippingFilter");
                }
                preferences.setValue("headerHtml", form.getHeader());
                preferences.setValue("footerHtml", form.getFooter());
                if (StringUtils.isNotBlank((String)form.getHeader()) || StringUtils.isNotBlank((String)form.getFooter())) {
                    filters.add("headerFooterFilter");
                }
                if ("httpContentService".equals(form.getContentService())) {
                    filters.add("urlRewritingFilter");
                }
                preferences.setValues("filters", filters.toArray(new String[0]));
                ArrayList<String> preInterceptors = new ArrayList<String>();
                preInterceptors.add("userInfoUrlParameterizingPreInterceptor");
                ProxyPortletForm.ProxyAuthType authType = form.getAuthType();
                if (authType.equals((Object)ProxyPortletForm.ProxyAuthType.BASIC)) {
                    preInterceptors.add("userInfoBasicAuthenticationPreInterceptor");
                } else if (authType.equals((Object)ProxyPortletForm.ProxyAuthType.CAS)) {
                    preInterceptors.add("proxyCASAuthenticationPreInterceptor");
                }
                preferences.setValue("authType", form.getAuthType().toString());
                preferences.setValues("preInterceptors", preInterceptors.toArray(new String[0]));
                preferences.setValue("gsaHost", form.getGsaHost());
                preferences.setValue("gsaCollection", form.getGsaCollection());
                preferences.setValue("gsaFrontend", form.getGsaFrontend());
                preferences.setValue("gsaWhitelistRegex", form.getGsaWhitelistRegex());
                preferences.setValue("anchorWhitelistRegex", form.getAnchorWhitelistRegex());
                preferences.setValues("searchStrategies", form.getSearchStrategies());
                preferences.store();
            }
            catch (Exception e) {
                this.log.error("Unable to update web proxy portlet configuration", (Throwable)e);
            }
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    public ProxyPortletForm getForm(PortletRequest request) {
        PortletPreferences preferences = request.getPreferences();
        ProxyPortletForm form = new ProxyPortletForm();
        form.setContentService(preferences.getValue("contentService", null));
        form.setLocation(preferences.getValue("location", null));
        form.setMaxLocation(preferences.getValue("location.MAXIMIZED", null));
        form.setWhitelistRegexes(preferences.getValue("whitelistRegexes", null));
        form.setPageCharacterEncodingFormat(preferences.getValue("sourcePageCharacterEncoding", "UTF-8"));
        form.setClippingSelector(preferences.getValue("clippingSelector", null));
        form.setHeader(preferences.getValue("headerHtml", null));
        form.setFooter(preferences.getValue("footerHtml", null));
        form.setGsaHost(preferences.getValue("gsaHost", null));
        form.setGsaCollection(preferences.getValue("gsaCollection", null));
        form.setGsaFrontend(preferences.getValue("gsaFrontend", null));
        form.setGsaWhitelistRegex(preferences.getValue("gsaWhitelistRegex", null));
        form.setAnchorWhitelistRegex(preferences.getValue("anchorWhitelistRegex", null));
        form.setSearchStrategies(preferences.getValues("searchStrategies", new String[0]));
        String authTypeForm = preferences.getValue("authType", null);
        ProxyPortletForm.ProxyAuthType authType = ProxyPortletForm.ProxyAuthType.NONE;
        if (!StringUtils.isBlank((String)authTypeForm)) {
            authType = ProxyPortletForm.ProxyAuthType.valueOf(authTypeForm);
        }
        form.setAuthType(authType);
        return form;
    }
}

