/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.PortletPreferences;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portal.search.SearchResults;
import org.jasig.portlet.proxy.search.ISearchService;
import org.jasig.portlet.proxy.search.ISearchStrategy;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchService
implements ISearchService {
    public static final String SEARCH_STRATEGIES_PREFERENCE = "searchStrategies";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, ISearchStrategy> strategies = new HashMap<String, ISearchStrategy>();

    @Override
    public void addSearchStrategy(ISearchStrategy strategy) {
        this.strategies.put(strategy.getStrategyName(), strategy);
    }

    @Override
    public String[] getStrategyNames() {
        return this.strategies.keySet().toArray(new String[0]);
    }

    @Override
    public SearchResults search(EventRequest request, Document document) {
        Event event = request.getEvent();
        SearchRequest searchQuery = (SearchRequest)event.getValue();
        SearchResults searchResults = new SearchResults();
        searchResults.setQueryId(searchQuery.getQueryId());
        searchResults.setWindowId(request.getWindowID());
        PortletPreferences preferences = request.getPreferences();
        String[] strategyNames = preferences.getValues(SEARCH_STRATEGIES_PREFERENCE, new String[0]);
        for (int i = 0; i < strategyNames.length; ++i) {
            ISearchStrategy strategy = this.strategies.get(strategyNames[i]);
            if (strategy == null) continue;
            List<SearchResult> results = strategy.search(searchQuery, request, document);
            searchResults.getSearchResult().addAll(results);
        }
        return searchResults;
    }
}

