/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.EventRequest;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portal.search.PortletUrl;
import org.jasig.portal.search.PortletUrlParameter;
import org.jasig.portal.search.PortletUrlType;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portlet.proxy.search.ISearchService;
import org.jasig.portlet.proxy.search.ISearchStrategy;
import org.jasig.portlet.proxy.search.util.SearchUtil;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public class GsaSearchStrategy
implements ISearchStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISearchService contentSearchProvider;

    @Required
    @Resource(name="contentSearchProvider")
    public void setContentSearchProvider(ISearchService contentSearchProvider) {
        this.contentSearchProvider = contentSearchProvider;
    }

    @PostConstruct
    public void init() {
        this.contentSearchProvider.addSearchStrategy(this);
    }

    @Override
    public String getStrategyName() {
        return "GSA";
    }

    @Override
    public List<SearchResult> search(SearchRequest searchQuery, EventRequest request, Document ignore) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        String searchBaseURL = this.buildGsaUrl(searchQuery, request);
        DecompressingHttpClient client = new DecompressingHttpClient((HttpClient)new DefaultHttpClient());
        HttpGet get = new HttpGet(searchBaseURL);
        try {
            HttpResponse httpResponse = client.execute((HttpUriRequest)get);
            this.log.debug("STATUS CODE :: " + httpResponse.getStatusLine().getStatusCode());
            InputStream in = httpResponse.getEntity().getContent();
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(in);
            this.log.debug("GOT InputSource");
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            Integer maxCount = Integer.parseInt(xPath.evaluate("count(/GSP/RES/R)", doc));
            String[] whitelistRegexes = request.getPreferences().getValues("gsaWhitelistRegex", new String[0]);
            this.log.debug(maxCount + " -- Results");
            for (int count = 1; count <= maxCount; ++count) {
                String u = xPath.evaluate("/GSP/RES/R[" + count + "]/U/text()", doc);
                String t = xPath.evaluate("/GSP/RES/R[" + count + "]/T/text()", doc);
                String s = xPath.evaluate("/GSP/RES/R[" + count + "]/S/text()", doc);
                this.log.debug("title: [" + t + "]");
                SearchResult result = new SearchResult();
                result.setTitle(t);
                result.setSummary(s);
                PortletUrl pUrl = new PortletUrl();
                pUrl.setPortletMode(PortletMode.VIEW.toString());
                pUrl.setType(PortletUrlType.RENDER);
                pUrl.setWindowState(WindowState.MAXIMIZED.toString());
                PortletUrlParameter param = new PortletUrlParameter();
                param.setName("proxy.url");
                param.getValue().add(u);
                pUrl.getParam().add(param);
                result.setPortletUrl(pUrl);
                new SearchUtil().updateUrls(u, (PortletRequest)request, whitelistRegexes);
                searchResults.add(result);
            }
        }
        catch (IOException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (XPathExpressionException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        catch (SAXException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
        return searchResults;
    }

    private String buildGsaUrl(SearchRequest searchQuery, EventRequest request) {
        String searchTerms = "";
        try {
            searchTerms = URLEncoder.encode(searchQuery.getSearchTerms(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.warn("Search term cannot be converted to UTF-8", (Throwable)e);
        }
        String gsa = request.getPreferences().getValue("gsaHost", "");
        String collection = request.getPreferences().getValue("gsaCollection", "");
        String frontend = request.getPreferences().getValue("gsaFrontend", "");
        if (gsa.equals("") || collection.equals("") || frontend.equals("")) {
            this.log.info("NOT Configured for search -- GSA:" + gsa + " -- COLLECTION:" + collection + " -- frontend:" + frontend);
        }
        String searchBaseURL = "http://" + gsa + "/search?q=" + searchTerms + "&site=" + collection + "&client=" + frontend + "&output=xml_no_dtd";
        this.log.debug(searchBaseURL);
        return searchBaseURL;
    }
}

