/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.mvc.portlet.gateway;

import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.proxy.mvc.IViewSelector;
import org.jasig.portlet.proxy.mvc.portlet.gateway.BaseGatewayPortletController;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayEntry;
import org.jasig.portlet.proxy.mvc.portlet.gateway.GatewayPreference;
import org.jasig.portlet.proxy.mvc.portlet.utilities.ActionScopedRequestAttributeManager;
import org.jasig.portlet.proxy.security.IStringEncryptionService;
import org.jasig.portlet.proxy.security.StringEncryptionException;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class GatewayPortletEditController
extends BaseGatewayPortletController {
    public static final String INCONSISTENT_FIELD_VALUES = "edit.proxy.error.message.inconsistent.field.values";
    public static final String GATEWAY_ENTRY_PREFERENCES = "gatewayPreferences";
    public static final String ERROR_KEY = "error";
    public static final String GATEWAY_ENTRY = "gatewayEntry";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="gatewayEntries")
    private List<GatewayEntry> gatewayEntries;
    private String preferencesRegex;
    @Autowired
    ActionScopedRequestAttributeManager actionScopedRequestAttributeManager;
    private IStringEncryptionService stringEncryptionService;
    @Autowired(required=false)
    private String viewName = "gatewayEdit";
    @Autowired(required=false)
    private String mobileViewName = "mobileGatewayEdit";
    @Autowired(required=true)
    private IViewSelector viewSelector;

    @Value(value="${login.preferences.regex}")
    public void setPreferencesRegex(String preferencesRegex) {
        this.preferencesRegex = preferencesRegex;
    }

    @Autowired(required=false)
    public void setStringEncryptionService(IStringEncryptionService stringEncryptionService) {
        this.stringEncryptionService = stringEncryptionService;
    }

    @RenderMapping
    public ModelAndView displayEditView(RenderRequest request, @RequestParam(required=false) String entryName) {
        ModelAndView mv = new ModelAndView();
        GatewayEntry entry = this.getGatewayEntry(entryName);
        mv.addObject(GATEWAY_ENTRY, (Object)entry);
        this.actionScopedRequestAttributeManager.propogateAndReturnItem(request, ERROR_KEY);
        TreeMap preferencesForEntry = (TreeMap)this.actionScopedRequestAttributeManager.propogateAndReturnItem(request, GATEWAY_ENTRY_PREFERENCES);
        if (preferencesForEntry == null) {
            PortletPreferences prefs = request.getPreferences();
            preferencesForEntry = this.getPreferencesForEntry(entry, prefs);
        }
        mv.addObject(GATEWAY_ENTRY_PREFERENCES, preferencesForEntry.descendingMap());
        mv.setView((Object)(this.viewSelector.isMobile((PortletRequest)request) ? this.mobileViewName : this.viewName));
        return mv;
    }

    @ActionMapping(params={"action=savePreferences"})
    public void savePreferences(ActionRequest request, ActionResponse response, @RequestParam String entryName) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        GatewayEntry entry = this.getGatewayEntry(entryName);
        TreeMap gatewayPreferenceMap = this.getPreferencesForEntry(entry, prefs);
        Enumeration parameterNames = request.getParameterNames();
        boolean foundBlank = false;
        boolean foundNonBlank = false;
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.matches(this.preferencesRegex)) continue;
            String parameterValue = request.getParameter(parameterName).trim();
            IFormField parameter = this.getPortletPreferenceFormField(parameterName);
            ((GatewayPreference)gatewayPreferenceMap.get(parameterName)).setFieldValue(parameterValue);
            boolean paramIsBlank = StringUtils.isBlank((String)parameterValue);
            foundBlank |= paramIsBlank;
            foundNonBlank |= !paramIsBlank;
            if (parameter != null && parameter.getSecured() && !paramIsBlank) {
                if (this.stringEncryptionService == null) {
                    throw new StringEncryptionException("String encryption service must be configured!");
                }
                parameterValue = this.stringEncryptionService.encrypt(parameterValue);
            }
            prefs.setValue(parameterName, parameterValue);
        }
        if (foundBlank && foundNonBlank) {
            response.setRenderParameter("entryName", entryName);
            this.actionScopedRequestAttributeManager.storeItem((PortletRequest)request, ERROR_KEY, (Object)INCONSISTENT_FIELD_VALUES);
            this.actionScopedRequestAttributeManager.storeItem((PortletRequest)request, GATEWAY_ENTRY_PREFERENCES, (Object)gatewayPreferenceMap);
        } else {
            prefs.store();
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @ActionMapping(params={"action=clearPreferences"})
    public void clearPreferences(ActionRequest request, ActionResponse response, @RequestParam String entryName) throws Exception {
        PortletPreferences prefs = request.getPreferences();
        GatewayEntry entry = this.getEntryByName(entryName);
        if (entry != null) {
            TreeMap preferences = this.getPreferencesForEntry(entry, prefs);
            for (GatewayPreference p : preferences.values()) {
                prefs.reset(p.getPreferenceName());
            }
            prefs.store();
        }
        response.setPortletMode(PortletMode.VIEW);
    }

    private GatewayEntry getGatewayEntry(String entryName) {
        GatewayEntry entry;
        GatewayEntry gatewayEntry = entry = entryName != null ? this.getEntryByName(entryName) : null;
        if (entry == null && this.gatewayEntries.size() != 0) {
            entry = (GatewayEntry)this.gatewayEntries.get(0);
        }
        if (entry == null) {
            throw new RuntimeException("No GatewayEntry objects are defined");
        }
        return entry;
    }

    private GatewayEntry getEntryByName(String entryName) {
        if (entryName == null) {
            String msg = "Parameter 'entryName' cannot be null";
            throw new IllegalArgumentException(msg);
        }
        GatewayEntry rslt = null;
        for (GatewayEntry y : this.gatewayEntries) {
            if (!y.getName().equalsIgnoreCase(entryName)) continue;
            rslt = y;
            break;
        }
        return rslt;
    }

    private TreeMap<String, GatewayPreference> getPreferencesForEntry(GatewayEntry entry, PortletPreferences prefs) {
        TreeMap<String, GatewayPreference> rslt = new TreeMap<String, GatewayPreference>();
        for (Map.Entry requestEntry : entry.getContentRequests().entrySet()) {
            HttpContentRequestImpl contentRequest = (HttpContentRequestImpl)requestEntry.getKey();
            Map parameters = contentRequest.getParameters();
            for (String logicalFieldName : parameters.keySet()) {
                IFormField parameter = (IFormField)parameters.get(logicalFieldName);
                for (String parameterValue : parameter.getValues()) {
                    String preferenceName;
                    if (!parameterValue.matches(this.preferencesRegex) || rslt.containsKey(preferenceName = parameterValue)) continue;
                    String preferredValue = prefs.getValue(preferenceName, "");
                    if (parameter.getSecured() && StringUtils.isNotBlank((String)preferredValue) && this.stringEncryptionService != null) {
                        preferredValue = this.stringEncryptionService.decrypt(preferredValue);
                    }
                    rslt.put(preferenceName, new GatewayPreference(entry.getName(), logicalFieldName, preferenceName, preferredValue, parameter.getSecured()));
                }
            }
        }
        return rslt;
    }

    private IFormField getPortletPreferenceFormField(String fieldName) {
        IFormField formField = null;
        for (GatewayEntry entry : this.gatewayEntries) {
            block1: for (Map.Entry requestEntry : entry.getContentRequests().entrySet()) {
                HttpContentRequestImpl contentRequest = (HttpContentRequestImpl)requestEntry.getKey();
                Map parameters = contentRequest.getParameters();
                for (String parameterNames : parameters.keySet()) {
                    IFormField parameter = (IFormField)parameters.get(parameterNames);
                    if (!parameter.getValue().equals(fieldName)) continue;
                    formField = parameter;
                    continue block1;
                }
            }
            if (formField == null) continue;
            break;
        }
        return formField;
    }
}

