/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.proxy.document;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.jasig.portlet.proxy.service.IContentResponse;
import org.jasig.portlet.proxy.service.proxy.document.IDocumentFilter;
import org.jasig.portlet.proxy.service.proxy.document.URLRewritingFilter;
import org.jasig.portlet.proxy.service.web.HttpContentServiceImpl;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.portlet.util.PortletUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="urlRewritingFilter")
public class URLRewritingFilter
implements IDocumentFilter {
    public static final String REWRITTEN_URLS_KEY = "rewrittenUrls";
    public static final String WHITELIST_REGEXES_KEY = "whitelistRegexes";
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private Map<String, Set<String>> actionElements;
    private Map<String, Set<String>> resourceElements;

    @Resource(name="urlRewritingActionElements")
    public void setActionElements(Map<String, Set<String>> actionElements) {
        this.actionElements = actionElements;
    }

    @Resource(name="urlRewritingResourceElements")
    public void setResourceElements(Map<String, Set<String>> resourceElements) {
        this.resourceElements = resourceElements;
    }

    public void filter(Document document, IContentResponse proxyResponse, RenderRequest request, RenderResponse response) {
        this.updateUrls(document, proxyResponse, this.actionElements, request, response, true);
        this.updateUrls(document, proxyResponse, this.resourceElements, request, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUrls(Document document, IContentResponse proxyResponse, Map<String, Set<String>> elementSet, RenderRequest request, RenderResponse response, boolean action) {
        ConcurrentHashMap<String, String> rewrittenUrls;
        PortletSession session = request.getPortletSession();
        Object object = PortletUtils.getSessionMutex((PortletSession)session);
        synchronized (object) {
            rewrittenUrls = (ConcurrentHashMap<String, String>)session.getAttribute("rewrittenUrls");
            if (rewrittenUrls == null) {
                rewrittenUrls = new ConcurrentHashMap<String, String>();
                session.setAttribute("rewrittenUrls", rewrittenUrls);
            }
        }
        PortletPreferences preferences = request.getPreferences();
        String[] whitelistRegexes = preferences.getValues("whitelistRegexes", new String[0]);
        String baseUrl = null;
        String relativeUrl = null;
        try {
            baseUrl = this.getBaseServerUrl(proxyResponse.getProxiedLocation());
            relativeUrl = this.getRelativePathUrl(proxyResponse.getProxiedLocation());
            this.LOG.trace("Computed base url {} and relative url {} for proxied url {}", new Object[]{baseUrl, relativeUrl, proxyResponse.getProxiedLocation()});
        }
        catch (URISyntaxException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
        for (Map.Entry<String, Set<String>> elementEntry : elementSet.entrySet()) {
            for (String attributeName : elementEntry.getValue()) {
                Elements elements = document.getElementsByTag(elementEntry.getKey());
                for (Element element : elements) {
                    String attributeUrl = element.attr(attributeName);
                    this.LOG.trace("Considering element {}  with URL attribute {} of value {}", new Object[]{element, attributeName, attributeUrl});
                    if (StringUtils.isBlank((String)attributeUrl)) continue;
                    boolean ignorable = false;
                    for (IgnorableProtocol ignorableProtocol : IgnorableProtocol.values()) {
                        if (!attributeUrl.toLowerCase().startsWith(ignorableProtocol.getPrefix())) continue;
                        ignorable = true;
                    }
                    if (ignorable) continue;
                    if (baseUrl != null && !attributeUrl.contains("://") && !attributeUrl.startsWith("//")) {
                        attributeUrl = attributeUrl.startsWith("/") ? baseUrl.concat(attributeUrl) : relativeUrl.concat(attributeUrl);
                    }
                    for (String string : whitelistRegexes) {
                        Pattern pattern;
                        if (!StringUtils.isNotBlank((String)string) || !(pattern = Pattern.compile(string)).matcher(attributeUrl).find()) continue;
                        rewrittenUrls.put(attributeUrl, attributeUrl);
                        if (elementEntry.getKey().equals("form")) {
                            boolean isPost = "POST".equalsIgnoreCase(element.attr("method"));
                            if (!isPost) {
                                element.attr("method", "POST");
                            }
                            attributeUrl = this.createFormUrl(response, isPost, attributeUrl);
                            continue;
                        }
                        attributeUrl = action ? this.createActionUrl(response, attributeUrl) : this.createResourceUrl(response, attributeUrl);
                    }
                    element.attr(attributeName, attributeUrl.replace("&amp;", "&"));
                }
            }
        }
    }

    protected String createFormUrl(RenderResponse response, boolean isPost, String url) {
        PortletURL portletUrl = response.createActionURL();
        portletUrl.setParameter(HttpContentServiceImpl.URL_PARAM, url);
        portletUrl.setParameter(HttpContentServiceImpl.IS_FORM_PARAM, "true");
        portletUrl.setParameter(HttpContentServiceImpl.FORM_METHOD_PARAM, isPost ? "POST" : "GET");
        return portletUrl.toString();
    }

    protected String createActionUrl(RenderResponse response, String url) {
        PortletURL portletUrl = response.createActionURL();
        portletUrl.setParameter(HttpContentServiceImpl.URL_PARAM, url);
        return portletUrl.toString();
    }

    protected String createResourceUrl(RenderResponse response, String url) {
        ResourceURL resourceUrl = response.createResourceURL();
        resourceUrl.setParameter(HttpContentServiceImpl.URL_PARAM, url);
        return resourceUrl.toString();
    }

    protected String getBaseServerUrl(String fullUrl) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(fullUrl);
        uriBuilder.removeQuery();
        uriBuilder.setPath("");
        return uriBuilder.build().toString();
    }

    protected String getRelativePathUrl(String fullUrl) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(fullUrl);
        uriBuilder.removeQuery();
        String path = uriBuilder.getPath();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            uriBuilder.setPath("");
        } else {
            uriBuilder.setPath(path.substring(0, lastSlash + 1));
        }
        return uriBuilder.build().toString();
    }
}

