/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.search;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.portlet.EventRequest;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.jasig.portal.search.PortletUrl;
import org.jasig.portal.search.PortletUrlParameter;
import org.jasig.portal.search.PortletUrlType;
import org.jasig.portal.search.SearchRequest;
import org.jasig.portal.search.SearchResult;
import org.jasig.portlet.proxy.search.ISearchService;
import org.jasig.portlet.proxy.search.ISearchStrategy;
import org.jasig.portlet.proxy.search.util.SearchUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class AnchorSearchStrategy
implements ISearchStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISearchService contentSearchProvider;

    @Required
    @Resource(name="contentSearchProvider")
    public void setContentSearchProvider(ISearchService contentSearchProvider) {
        this.contentSearchProvider = contentSearchProvider;
    }

    @PostConstruct
    public void init() {
        this.contentSearchProvider.addSearchStrategy((ISearchStrategy)this);
    }

    public String getStrategyName() {
        return "Anchor";
    }

    public List<SearchResult> search(SearchRequest searchQuery, EventRequest request, Document document) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String[] whitelistRegexes = request.getPreferences().getValues("anchorWhitelistRegex", new String[0]);
        String searchTerms = searchQuery.getSearchTerms().toLowerCase();
        Elements links = document.select("a[href]");
        for (Element link : links) {
            String linkUrl = link.attr("abs:href");
            for (String searchTerm : searchTerms.split(" ")) {
                if (!link.text().toLowerCase().contains(searchTerm)) continue;
                this.log.debug("found a match, term: [" + searchTerm + "], anchor URL: [" + linkUrl + "], anchor text: [" + link.text() + "]");
                SearchResult result = new SearchResult();
                result.setTitle(link.text());
                result.setSummary(link.text());
                PortletUrl pUrl = new PortletUrl();
                pUrl.setPortletMode(PortletMode.VIEW.toString());
                pUrl.setType(PortletUrlType.RENDER);
                pUrl.setWindowState(WindowState.MAXIMIZED.toString());
                PortletUrlParameter param = new PortletUrlParameter();
                param.setName("proxy.url");
                param.getValue().add(linkUrl);
                pUrl.getParam().add(param);
                new SearchUtil().updateUrls(linkUrl, (PortletRequest)request, whitelistRegexes);
                result.setPortletUrl(pUrl);
                results.add(result);
            }
        }
        return results;
    }
}

