/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jasig.portlet.proxy.service.GenericContentResponseImpl;
import org.jasig.portlet.proxy.service.IContentService;
import org.jasig.portlet.proxy.service.IFormField;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.HttpContentResponseImpl;
import org.jasig.portlet.proxy.service.web.IHttpClientService;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.jasig.portlet.spring.IExpressionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="httpContentService")
public class HttpContentServiceImpl
implements IContentService<HttpContentRequestImpl, GenericContentResponseImpl> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PROXY_PORTLET_PARAM_PREFIX = "proxy.";
    public static final String URL_PARAM = "proxy.".concat("url");
    public static final String IS_FORM_PARAM = "proxy.".concat("isForm");
    public static final String FORM_METHOD_PARAM = "proxy.".concat("formMethod");
    public static final String PREINTERCEPTOR_LIST_KEY = "preInterceptors";
    private ApplicationContext applicationContext;
    private IHttpClientService httpClientService;
    private List<String> replayedRequestHeaders;
    @Autowired(required=true)
    private IExpressionProcessor expressionParser;

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Autowired(required=true)
    public void setHttpClientService(IHttpClientService httpClientService) {
        this.httpClientService = httpClientService;
    }

    @Required
    @Resource(name="replayedRequestHeaders")
    public void setReplayedRequestHeaders(List<String> replayedRequestHeaders) {
        this.replayedRequestHeaders = replayedRequestHeaders;
    }

    public HttpContentRequestImpl getRequest(PortletRequest request) {
        HttpContentRequestImpl contentRequest = new HttpContentRequestImpl(request, this.expressionParser);
        for (String headerName : this.replayedRequestHeaders) {
            String headerValue = request.getProperty(headerName);
            if (headerValue == null) continue;
            contentRequest.getHeaders().put(headerName, headerValue);
        }
        return contentRequest;
    }

    public void beforeGetContent(HttpContentRequestImpl proxyRequest, PortletRequest request) {
        String[] interceptorKeys;
        PortletPreferences preferences = request.getPreferences();
        for (String key : interceptorKeys = preferences.getValues(PREINTERCEPTOR_LIST_KEY, new String[0])) {
            IPreInterceptor preinterceptor = (IPreInterceptor)this.applicationContext.getBean(key, IPreInterceptor.class);
            preinterceptor.intercept(proxyRequest, request);
        }
    }

    public GenericContentResponseImpl getContent(HttpContentRequestImpl proxyRequest, PortletRequest request) {
        this.beforeGetContent(proxyRequest, request);
        return this.getContent(proxyRequest, request, true);
    }

    public GenericContentResponseImpl getContent(HttpContentRequestImpl proxyRequest, PortletRequest request, boolean runWrapperMethods) {
        try {
            AbstractHttpClient httpclient = this.httpClientService.getHttpClient(request);
            HttpUriRequest httpRequest = this.getHttpRequest(proxyRequest, request);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Proxying " + httpRequest.getURI() + " via " + httpRequest.getMethod());
            }
            BasicHttpContext context = new BasicHttpContext();
            HttpResponse response = httpclient.execute(httpRequest, (HttpContext)context);
            HttpEntity entity = response.getEntity();
            HttpContentResponseImpl proxyResponse = new HttpContentResponseImpl(entity);
            proxyResponse.setContent(entity.getContent());
            for (Header header : response.getAllHeaders()) {
                proxyResponse.getHeaders().put(header.getName(), header.getValue());
            }
            String finalUrl = (String)context.getAttribute("finalUrl");
            if (finalUrl == null) {
                finalUrl = proxyRequest.getProxiedLocation();
            }
            proxyResponse.setProxiedLocation(finalUrl);
            return proxyResponse;
        }
        catch (ClientProtocolException e) {
            this.log.error("Exception retrieving remote content", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Exception retrieving remote content", (Throwable)e);
        }
        return null;
    }

    public void afterGetContent(HttpContentRequestImpl proxyRequest, PortletRequest request, GenericContentResponseImpl proxyResponse) {
    }

    /*
     * Unable to fully structure code
     */
    protected HttpUriRequest getHttpRequest(HttpContentRequestImpl proxyRequest, PortletRequest request) {
        if (proxyRequest.isForm()) {
            params = proxyRequest.getParameters();
            if ("POST".equalsIgnoreCase(proxyRequest.getMethod())) {
                pairs = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<K, V> param : params.entrySet()) {
                    for (String value : ((IFormField)param.getValue()).getValues()) {
                        if (value == null) continue;
                        pairs.add(new BasicNameValuePair((String)param.getKey(), value));
                    }
                }
                try {
                    httpRequest = new HttpPost(proxyRequest.getProxiedLocation());
                    if (pairs.size() <= 0) ** GOTO lbl36
                    ((HttpPost)httpRequest).setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error("Failed to encode form parameters", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    builder = new URIBuilder(proxyRequest.getProxiedLocation());
                    for (Map.Entry<K, V> param : params.entrySet()) {
                        for (String value : ((IFormField)param.getValue()).getValues()) {
                            builder.addParameter((String)param.getKey(), value);
                        }
                    }
                    uri = builder.build();
                    httpRequest = new HttpGet(uri);
                }
                catch (URISyntaxException e) {
                    this.log.error("Failed to build URI for proxying", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.log.debug("Submitting a GET request to proxied location [{}]", (Object)proxyRequest.getProxiedLocation());
            httpRequest = new HttpGet(proxyRequest.getProxiedLocation());
        }
lbl36:
        // 5 sources

        for (Map.Entry<K, V> header : proxyRequest.getHeaders().entrySet()) {
            httpRequest.setHeader((String)header.getKey(), (String)header.getValue());
        }
        return httpRequest;
    }
}

