/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.proxy.service.web.interceptor;

import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.jasig.portlet.proxy.service.web.HttpContentRequestImpl;
import org.jasig.portlet.proxy.service.web.interceptor.IPreInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="headerPassingPreInterceptor")
public class HeaderPassingPreInterceptor
implements IPreInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String HEADER_PREFERENCE_NAMES = "headerNames";
    public static final String HEADER_PREFERENCE_VALUES = "headerValues";

    @Override
    public void intercept(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        String[] headerValues;
        PortletPreferences prefs = portletRequest.getPreferences();
        String[] headerNames = prefs.getValues(HEADER_PREFERENCE_NAMES, new String[0]);
        if (headerNames.length == (headerValues = prefs.getValues(HEADER_PREFERENCE_VALUES, new String[0])).length) {
            Map userInfo = (Map)portletRequest.getAttribute("javax.portlet.userinfo");
            Map<String, String> headerMap = proxyRequest.getHeaders();
            for (int i = 0; i < headerNames.length; ++i) {
                String headerName = headerNames[i];
                String headerValue = (String)userInfo.get(headerValues[i]);
                headerMap.put(headerName, headerValue);
            }
            proxyRequest.setHeaders(headerMap);
        } else {
            this.logger.warn("Invalid data in preferences. Header name array length does not equal header value array length");
        }
    }

    @Override
    public boolean validate(HttpContentRequestImpl proxyRequest, PortletRequest portletRequest) {
        return true;
    }
}

